/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio.osx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformPCSC {
    private static final String PCSC_JNI_LIBRARY_PATH = "/at/gv/egiz/smcc/osx-pcsc-jni/";
    private static final String PCSC_JNI_LIBRARY_NAME = "libosxj2pcsc.dylib";
    private static final String PCSC_FRAMEWORK = "/System/Library/Frameworks/PCSC.framework/Versions/Current/PCSC";
    private static final Logger log = LoggerFactory.getLogger(PlatformPCSC.class);
    public static final int SCARD_PROTOCOL_T0 = 1;
    public static final int SCARD_PROTOCOL_T1 = 2;
    public static final int SCARD_PROTOCOL_RAW = 4;
    public static final int SCARD_UNKNOWN = 1;
    public static final int SCARD_ABSENT = 2;
    public static final int SCARD_PRESENT = 4;
    public static final int SCARD_SWALLOWED = 8;
    public static final int SCARD_POWERED = 16;
    public static final int SCARD_NEGOTIABLE = 32;
    public static final int SCARD_SPECIFIC = 64;
    public static final Exception INIT_EXCEPTION = AccessController.doPrivileged(new PrivilegedAction<Exception>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception run() {
            try {
                String[] stringArray = PlatformPCSC.PCSC_JNI_LIBRARY_NAME.split("\\.");
                File file = File.createTempFile(stringArray[0], stringArray[1]);
                file.deleteOnExit();
                log.debug("Copying /at/gv/egiz/smcc/osx-pcsc-jni/" + PlatformPCSC.getLibrary() + " to " + file);
                InputStream inputStream = PlatformPCSC.class.getResourceAsStream(PlatformPCSC.PCSC_JNI_LIBRARY_PATH + PlatformPCSC.getLibrary());
                if (inputStream == null) {
                    return new FileNotFoundException(PlatformPCSC.getLibrary() + " not found.");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    int n;
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    log.debug("loading " + file.getAbsolutePath());
                    System.load(file.getAbsolutePath());
                    PlatformPCSC.initialize(PlatformPCSC.PCSC_FRAMEWORK);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                    inputStream.close();
                }
                return null;
            }
            catch (Exception exception) {
                return exception;
            }
        }
    });

    private static String getLibrary() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.6")) {
            return "jre6.libosxj2pcsc.dylib";
        }
        if (string.startsWith("1.7")) {
            return "jre7.libosxj2pcsc.dylib";
        }
        if (string.startsWith("1.8")) {
            return "jre8.libosxj2pcsc.dylib";
        }
        return null;
    }

    private static native void initialize(String var0);
}

