/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.windows.keystore;

import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.MSCAPISignatureToken;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.util.ArrayList;
import java.util.List;
import lu.nowina.nexu.api.CertificateFilter;
import lu.nowina.nexu.api.CertificateFilterHelper;
import lu.nowina.nexu.api.GetIdentityInfoResponse;
import lu.nowina.nexu.api.MessageDisplayCallback;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.SystrayMenuItem;
import lu.nowina.nexu.api.flow.FutureOperationInvocation;
import lu.nowina.nexu.api.flow.NoOpFutureOperationInvocation;
import lu.nowina.nexu.windows.keystore.WindowsKeystore;

public class WindowsKeystoreProductAdapter
implements ProductAdapter {
    @Override
    public boolean accept(Product product) {
        return product instanceof WindowsKeystore;
    }

    @Override
    public String getLabel(NexuAPI api, Product product, PasswordInputCallback callback) {
        return product.getLabel();
    }

    @Override
    public String getLabel(NexuAPI api, Product product, PasswordInputCallback callback, MessageDisplayCallback messageCallback) {
        throw new IllegalStateException("This product adapter does not support message display callback.");
    }

    @Override
    public boolean supportMessageDisplayCallback(Product product) {
        return false;
    }

    @Override
    public SignatureTokenConnection connect(NexuAPI api, Product product, PasswordInputCallback callback) {
        return new MSCAPISignatureToken();
    }

    @Override
    public SignatureTokenConnection connect(NexuAPI api, Product product, PasswordInputCallback callback, MessageDisplayCallback messageCallback) {
        throw new IllegalStateException("This product adapter does not support message display callback.");
    }

    @Override
    public boolean canReturnIdentityInfo(Product product) {
        return false;
    }

    @Override
    public GetIdentityInfoResponse getIdentityInfo(SignatureTokenConnection token) {
        throw new IllegalStateException("This product adapter cannot return identity information.");
    }

    @Override
    public boolean supportCertificateFilter(Product product) {
        return true;
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys(SignatureTokenConnection token, CertificateFilter certificateFilter) {
        return new CertificateFilterHelper().filterKeys(token, certificateFilter);
    }

    @Override
    public boolean canReturnSuportedDigestAlgorithms(Product product) {
        return false;
    }

    @Override
    public List<DigestAlgorithm> getSupportedDigestAlgorithms(Product product) {
        throw new IllegalStateException("This product adapter cannot return list of supported digest algorithms.");
    }

    @Override
    public DigestAlgorithm getPreferredDigestAlgorithm(Product product) {
        throw new IllegalStateException("This product adapter cannot return list of supported digest algorithms.");
    }

    @Override
    public FutureOperationInvocation<Product> getConfigurationOperation(NexuAPI api, Product product) {
        return new NoOpFutureOperationInvocation<Product>(product);
    }

    @Override
    public FutureOperationInvocation<Boolean> getSaveOperation(NexuAPI api, Product product) {
        return new NoOpFutureOperationInvocation<Boolean>(true);
    }

    @Override
    public SystrayMenuItem getExtensionSystrayMenuItem() {
        return null;
    }

    public List<Product> detectProducts() {
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(new WindowsKeystore());
        return products;
    }
}

