/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;
import lu.nowina.nexu.api.DetectedCard;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.flow.StageHelper;
import lu.nowina.nexu.view.core.AbstractUIOperationController;

public class ProductSelectionController
extends AbstractUIOperationController<Product>
implements Initializable {
    @FXML
    private Label message;
    @FXML
    private Pane productsContainer;
    @FXML
    private Button select;
    @FXML
    private Button cancel;
    private ToggleGroup product;

    public void initialize(URL location, ResourceBundle resources) {
        this.select.setOnAction(e -> this.signalEnd(this.getSelectedProduct()));
        this.cancel.setOnAction(e -> this.signalUserCancel());
        this.product = new ToggleGroup();
        this.select.disableProperty().bind((ObservableValue)this.product.selectedToggleProperty().isNull());
    }

    private Product getSelectedProduct() {
        return (Product)this.product.getSelectedToggle().getUserData();
    }

    @Override
    public final void init(Object ... params) {
        NexuAPI api = (NexuAPI)params[3];
        StageHelper.getInstance().setTitle(api.getAppConfig().getApplicationName(), "product.selection.title");
        Platform.runLater(() -> {
            RadioButton button;
            this.message.setText(MessageFormat.format(ResourceBundle.getBundle("bundles/nexu").getString("product.selection.header"), params[0]));
            List cards = (List)params[1];
            List products = (List)params[2];
            ArrayList<RadioButton> radioButtons = new ArrayList<RadioButton>(cards.size() + products.size());
            for (DetectedCard card : cards) {
                button = new RadioButton(api.getLabel(card));
                button.setToggleGroup(this.product);
                button.setUserData((Object)card);
                button.setMnemonicParsing(false);
                radioButtons.add(button);
            }
            for (Product p : products) {
                button = new RadioButton(api.getLabel(p));
                button.setToggleGroup(this.product);
                button.setUserData((Object)p);
                button.setMnemonicParsing(false);
                radioButtons.add(button);
            }
            this.productsContainer.getChildren().addAll(radioButtons);
        });
    }
}

