/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import lu.nowina.nexu.api.ConfiguredKeystore;
import lu.nowina.nexu.api.KeystoreType;
import lu.nowina.nexu.keystore.KeystoreDatabase;
import lu.nowina.nexu.view.core.AbstractUIOperationController;

public class ManageKeystoresController
extends AbstractUIOperationController<Void>
implements Initializable {
    @FXML
    private Button remove;
    @FXML
    private TableView<ConfiguredKeystore> keystoresTable;
    @FXML
    private TableColumn<ConfiguredKeystore, String> keystoreNameTableColumn;
    @FXML
    private TableColumn<ConfiguredKeystore, KeystoreType> keystoreTypeTableColumn;
    @FXML
    private Label keystoreURL;
    private final ObservableList<ConfiguredKeystore> observableKeystores = FXCollections.observableArrayList();
    private KeystoreDatabase database;

    public void initialize(URL location, ResourceBundle resources) {
        this.keystoresTable.setPlaceholder((Node)new Label(resources.getString("table.view.no.content")));
        this.keystoresTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.keystoreNameTableColumn.setCellValueFactory(param -> {
            String url = ((ConfiguredKeystore)param.getValue()).getUrl();
            return new ReadOnlyStringWrapper(url.substring(url.lastIndexOf(47) + 1));
        });
        this.keystoreTypeTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.keystoresTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.keystoreURL.setText(newValue.getUrl());
            } else {
                this.keystoreURL.setText(null);
            }
        });
        this.keystoresTable.setItems(this.observableKeystores);
        this.remove.disableProperty().bind((ObservableValue)this.keystoresTable.getSelectionModel().selectedItemProperty().isNull());
        this.remove.setOnAction(event -> this.observableKeystores.remove(this.keystoresTable.getSelectionModel().getSelectedItem()));
        this.observableKeystores.addListener(c -> {
            while (c.next()) {
                for (ConfiguredKeystore removed : c.getRemoved()) {
                    this.database.remove(removed);
                }
            }
        });
    }

    @Override
    public void init(Object ... params) {
        this.database = (KeystoreDatabase)params[0];
        Platform.runLater(() -> this.observableKeystores.setAll(this.database.getKeystores()));
    }
}

