/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.ui;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.api.ConfiguredKeystore;
import lu.nowina.nexu.api.KeystoreType;
import lu.nowina.nexu.flow.StageHelper;
import lu.nowina.nexu.view.core.AbstractUIOperationController;
import lu.nowina.nexu.view.core.ExtensionFilter;

public class ConfigureKeystoreController
extends AbstractUIOperationController<ConfiguredKeystore>
implements Initializable {
    @FXML
    private Button ok;
    @FXML
    private Button cancel;
    @FXML
    private Button selectFile;
    @FXML
    private ComboBox<KeystoreType> keystoreType;
    private File keystoreFile;
    private final BooleanProperty keystoreFileSpecified = new SimpleBooleanProperty(false);

    @Override
    public void init(Object ... params) {
        StageHelper.getInstance().setTitle((String)params[0], "save.keystore.title");
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.ok.setOnAction(event -> {
            ConfiguredKeystore result = new ConfiguredKeystore();
            try {
                result.setUrl(this.keystoreFile.toURI().toURL().toString());
            }
            catch (Exception e1) {
                throw new NexuException(e1);
            }
            result.setType((KeystoreType)((Object)((Object)this.keystoreType.getValue())));
            result.setToBeSaved(true);
            this.signalEnd(result);
        });
        this.ok.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.keystoreFileSpecified));
        this.cancel.setOnAction(e -> this.signalUserCancel());
        this.selectFile.setOnAction(e -> {
            ExtensionFilter extensionFilter;
            switch ((KeystoreType)((Object)((Object)this.keystoreType.getValue()))) {
                case JKS: {
                    extensionFilter = new ExtensionFilter("JKS", "*.jks", "*.JKS");
                    break;
                }
                case PKCS12: {
                    extensionFilter = new ExtensionFilter("PKCS12", "*.p12", "*.pfx", "*.P12", "*.PFX");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown keystore type: " + this.keystoreType.getValue());
                }
            }
            this.keystoreFile = this.getDisplay().displayFileChooser(extensionFilter);
            this.keystoreFileSpecified.set(this.keystoreFile != null);
        });
        this.selectFile.disableProperty().bind((ObservableValue)this.keystoreType.valueProperty().isNull());
        this.keystoreType.getItems().setAll((Object[])KeystoreType.values());
    }
}

