/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.view.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import lu.nowina.nexu.api.flow.AbstractFutureOperationInvocation;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.FutureOperationInvocation;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.api.flow.OperationStatus;
import lu.nowina.nexu.flow.operation.UIDisplayAwareOperation;
import lu.nowina.nexu.view.core.UIDisplay;
import lu.nowina.nexu.view.core.UIOperationController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIOperation<R>
implements UIDisplayAwareOperation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIOperation.class.getName());
    private transient Object lock = new Object();
    private volatile transient OperationResult<R> result = null;
    private UIDisplay display;
    private String fxml;
    private Object[] params;
    private transient Parent root;
    private transient UIOperationController<R> controller;

    @Override
    public void setParams(Object ... params) {
        if (params.length < 1) {
            throw new IllegalArgumentException("An UIOperation needs at least the fxml.");
        }
        try {
            this.fxml = (String)params[0];
            if (params.length > 1) {
                this.params = params[1] instanceof Object[] ? (Object[])params[1] : Arrays.copyOfRange(params, 1, params.length);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected parameters: fxml, controller params.");
        }
    }

    @Override
    public final OperationResult<R> perform() {
        LOGGER.info("Loading " + this.fxml + " view");
        FXMLLoader loader = new FXMLLoader();
        try {
            loader.setResources(ResourceBundle.getBundle("bundles/nexu"));
            loader.load(this.getClass().getResourceAsStream(this.fxml));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.root = (Parent)loader.getRoot();
        this.controller = (UIOperationController)loader.getController();
        this.controller.init(this.params);
        this.controller.setUIOperation(this);
        this.controller.setDisplay(this.display);
        this.display();
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitEnd() throws InterruptedException {
        String name = this.getOperationName();
        LOGGER.info("Thread " + Thread.currentThread().getName() + " wait on " + name);
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
        LOGGER.info("Thread " + Thread.currentThread().getName() + " resumed on " + name);
    }

    public final void signalEnd(R result) {
        String name = this.getOperationName();
        LOGGER.info("Notify from " + Thread.currentThread().getName() + " on " + name);
        this.notifyResult(new OperationResult<R>(result));
        this.hide();
    }

    public final void signalEnd(OperationStatus operationStatus) {
        this.notifyResult(new OperationResult(operationStatus));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResult(OperationResult<R> result) {
        this.result = result;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public final void signalUserCancel() {
        this.notifyResult(new OperationResult(BasicOperationStatus.USER_CANCEL));
    }

    private String getOperationName() {
        return this.controller.getClass().getSimpleName();
    }

    public Parent getRoot() {
        return this.root;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.display == null ? 0 : this.display.hashCode());
        result = 31 * result + (this.fxml == null ? 0 : this.fxml.hashCode());
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UIOperation other = (UIOperation)obj;
        if (this.display == null ? other.display != null : !this.display.equals(other.display)) {
            return false;
        }
        if (this.fxml == null ? other.fxml != null : !this.fxml.equals(other.fxml)) {
            return false;
        }
        return Arrays.equals(this.params, other.params);
    }

    @Override
    public final void setDisplay(UIDisplay display) {
        this.display = display;
    }

    protected final UIDisplay getDisplay() {
        return this.display;
    }

    protected void display() {
        this.display.displayAndWaitUIOperation(this);
    }

    protected void hide() {
        this.display.close(true);
    }

    public static <R, T extends UIOperation<R>> FutureOperationInvocation<R> getFutureOperationInvocation(Class<T> operationClass, String fxml, Object ... controllerParams) {
        return new UIFutureOperationInvocation(operationClass, fxml, controllerParams);
    }

    private static class UIFutureOperationInvocation<R, T extends UIOperation<R>>
    extends AbstractFutureOperationInvocation<R> {
        private final Class<T> operationClass;
        private final String fxml;
        private final Object[] controllerParams;

        public UIFutureOperationInvocation(Class<T> operationClass, String fxml, Object ... controllerParams) {
            this.operationClass = operationClass;
            this.fxml = fxml;
            this.controllerParams = controllerParams;
        }

        @Override
        protected Class<T> getOperationClass() {
            return this.operationClass;
        }

        @Override
        protected Object[] getOperationParams() {
            Object[] objectArray;
            if (this.controllerParams != null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.fxml;
                objectArray = objectArray2;
                objectArray2[1] = this.controllerParams;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.fxml;
            }
            return objectArray;
        }
    }
}

