/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.systray;

import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import java.net.URL;
import lu.nowina.nexu.api.SystrayMenuItem;
import lu.nowina.nexu.api.flow.OperationFactory;
import lu.nowina.nexu.systray.SystrayMenuInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorkboxSystrayMenuInitializer
implements SystrayMenuInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DorkboxSystrayMenuInitializer.class.getName());

    @Override
    public void init(String tooltip, URL trayIconURL, OperationFactory operationFactory, SystrayMenuItem exitMenuItem, SystrayMenuItem ... systrayMenuItems) {
        SystemTray systemTray = SystemTray.getNative();
        if (systemTray == null) {
            LOGGER.warn("System tray is currently not supported.");
            return;
        }
        systemTray.setImage(trayIconURL);
        Menu menu = systemTray.getMenu();
        for (SystrayMenuItem systrayMenuItem : systrayMenuItems) {
            menu.add(new MenuItem(systrayMenuItem.getLabel(), e -> systrayMenuItem.getFutureOperationInvocation().call(operationFactory)));
        }
        menu.add(new MenuItem(exitMenuItem.getLabel(), e -> exitMenuItem.getFutureOperationInvocation().call(operationFactory)));
    }
}

