/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.jetty;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.OS;
import lu.nowina.nexu.jetty.RequestProcessor;
import lu.nowina.nexu.jetty.UserByPIDStrategy;
import lu.nowina.nexu.process.NativeProcessExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckUserRequestProcessor
extends RequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckUserRequestProcessor.class.getName());
    private static final OS OPERATING_SYSTEM = EnvironmentInfo.buildFromSystemProperties(System.getProperties()).getOs();
    private static final String EXPECTED_USERNAME = System.getProperty("user.name");
    private static final String PORT_TO_PID_PATTERN_PREFIX = "\\s+TCP\\s+[0-9a-f\\.]+:";
    private static final String PORT_TO_PID_PATTERN_SUFFIX = "\\s+[0-9a-f\\.:]+\\s+ESTABLISHED\\s+([0-9]+)";
    private final UserByPIDStrategy userByPIDStrategy;

    public CheckUserRequestProcessor() {
        try {
            switch (OPERATING_SYSTEM) {
                case WINDOWS: {
                    this.userByPIDStrategy = Class.forName("lu.nowina.nexu.jetty.Win32JNAUserByPIDStrategy").asSubclass(UserByPIDStrategy.class).newInstance();
                    break;
                }
                default: {
                    this.userByPIDStrategy = null;
                    break;
                }
            }
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected String returnNullIfValid(HttpServletRequest request) {
        if (!OS.WINDOWS.equals((Object)OPERATING_SYSTEM)) {
            return null;
        }
        int port = request.getRemotePort();
        int pid = this.getPID(port);
        String username = this.getUsername(pid);
        if (!EXPECTED_USERNAME.equals(username)) {
            return "Request comes from user " + username;
        }
        return null;
    }

    private int getPID(int port) {
        String netstatResult;
        Pattern pattern = Pattern.compile(PORT_TO_PID_PATTERN_PREFIX + port + PORT_TO_PID_PATTERN_SUFFIX);
        Matcher matcher = pattern.matcher(netstatResult = this.executeCommand("netstat -no"));
        if (!matcher.find()) {
            LOGGER.error("Pattern " + pattern.toString() + " cannot match " + netstatResult);
            throw new IllegalStateException("Cannot match pattern with netstat result");
        }
        return Integer.parseInt(matcher.group(1));
    }

    private String getUsername(int pid) {
        String username = this.userByPIDStrategy.getUserForPID(pid);
        LOGGER.info("User for pid " + pid + ": " + username);
        return username;
    }

    private String executeCommand(String command) {
        NativeProcessExecutor executor = new NativeProcessExecutor(command, 10000);
        int resultCode = executor.getResultCode();
        if (resultCode != 0) {
            throw new NexuException("Result code of " + command + " is different from 0: " + resultCode);
        }
        return executor.getResult();
    }
}

