/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.https;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class PKIManager {
    public KeyPair createKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public X509Certificate generateRootSelfSignedCertificate(PrivateKey pk, PublicKey p, Date membersNotBefore, Date membersNotAfter, String applicationName) {
        try {
            ContentSigner signer = new JcaContentSignerBuilder("SHA512withRSA").build(pk);
            X500Name name = this.getX500SubjectForRoot(applicationName);
            SubjectPublicKeyInfo membersKeyInfo = SubjectPublicKeyInfo.getInstance(p.getEncoded());
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(name, new BigInteger(Long.toString(new Random().nextLong())), membersNotBefore, membersNotAfter, name, membersKeyInfo);
            KeyUsage keyUsage = new KeyUsage(6);
            certBuilder.addExtension(Extension.keyUsage, true, keyUsage);
            certBuilder.addExtension(Extension.basicConstraints, true, new BasicConstraints(1));
            X509CertificateHolder cert = certBuilder.build(signer);
            return this.toX509Certificate(cert);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public X509Certificate generateCertificateForWebServer(PrivateKey rootPk, X509Certificate rootCert, PrivateKey pk, PublicKey p, Date membersNotBefore, Date membersNotAfter, String applicationName) {
        try {
            ContentSigner signer = new JcaContentSignerBuilder("SHA512withRSA").build(rootPk);
            X500Name rootX500Name = new JcaX509CertificateHolder(rootCert).getSubject();
            X500Name subjectX500Name = this.getX500SubjectForWebServer(applicationName);
            SubjectPublicKeyInfo membersKeyInfo = SubjectPublicKeyInfo.getInstance(p.getEncoded());
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(rootX500Name, new BigInteger(Long.toString(new Random().nextLong())), membersNotBefore, membersNotAfter, subjectX500Name, membersKeyInfo);
            KeyUsage keyUsage = new KeyUsage(160);
            certBuilder.addExtension(Extension.keyUsage, true, keyUsage);
            ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth});
            certBuilder.addExtension(Extension.extendedKeyUsage, false, extendedKeyUsage);
            GeneralNames names = new GeneralNames(new GeneralName(2, "localhost"));
            certBuilder.addExtension(Extension.subjectAlternativeName, false, names);
            certBuilder.addExtension(Extension.basicConstraints, true, new BasicConstraints(false));
            X509CertificateHolder cert = certBuilder.build(signer);
            return this.toX509Certificate(cert);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private X509Certificate toX509Certificate(X509CertificateHolder holder) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(holder.getEncoded()));
        }
        catch (IOException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private X500Name getX500SubjectForRoot(String applicationName) {
        X500NameBuilder builder = new X500NameBuilder();
        builder.addRDN(BCStyle.CN, "localhost");
        builder.addRDN(BCStyle.O, applicationName);
        builder.addRDN(BCStyle.C, "LU");
        return builder.build();
    }

    private X500Name getX500SubjectForWebServer(String applicationName) {
        X500NameBuilder builder = new X500NameBuilder();
        builder.addRDN(BCStyle.CN, "localhost");
        builder.addRDN(BCStyle.O, applicationName);
        builder.addRDN(BCStyle.OU, "webserver");
        builder.addRDN(BCStyle.C, "LU");
        return builder.build();
    }

    public File getRootCertificate(File nexuHome, final String applicationName) {
        Object[] files = nexuHome.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(applicationName + "-") && name.endsWith(".crt");
            }
        });
        if (files.length > 0) {
            Arrays.sort(files);
            return new File(nexuHome, (String)files[files.length - 1]);
        }
        return new File(nexuHome, "ca-cert.crt");
    }
}

