/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.https;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.plugin.InitializationMessage;
import lu.nowina.nexu.api.plugin.NexuPlugin;
import lu.nowina.nexu.https.PKIManager;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsPlugin
implements NexuPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsPlugin.class.getName());

    @Override
    public List<InitializationMessage> init(String pluginId, NexuAPI api) {
        File caCert;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("bundles/https");
        ResourceBundle baseResourceBundle = ResourceBundle.getBundle("bundles/nexu");
        LOGGER.info("Verify if keystore is ready");
        File nexuHome = api.getAppConfig().getNexuHome();
        File keyStoreFile = new File(nexuHome, "keystore.jks");
        File webServerKeyStoreFile = new File(nexuHome, "web-server-keystore.jks");
        PKIManager pki = new PKIManager();
        if (!keyStoreFile.exists()) {
            if (!webServerKeyStoreFile.exists()) {
                caCert = this.createRootCACert(nexuHome, api.getAppConfig().getApplicationName(), pki, webServerKeyStoreFile);
            } else {
                File testCaCert = pki.getRootCertificate(nexuHome, api.getAppConfig().getApplicationName());
                try {
                    if (!this.fulfillRequirements(testCaCert)) {
                        caCert = this.createRootCACert(nexuHome, api.getAppConfig().getApplicationName(), pki, webServerKeyStoreFile);
                    }
                    caCert = testCaCert;
                }
                catch (IOException | CertificateException e) {
                    LOGGER.warn("Exception when trying to determine if certificate fulfills requirements.", e);
                    return Arrays.asList(new InitializationMessage(InitializationMessage.MessageType.WARNING, resourceBundle.getString("warn.install.cert.title"), MessageFormat.format(resourceBundle.getString("warn.install.cert.header"), api.getAppConfig().getApplicationName(), "requirements"), baseResourceBundle.getString("contact.application.provider")));
                }
            }
        } else {
            File testCaCert = pki.getRootCertificate(nexuHome, api.getAppConfig().getApplicationName());
            try {
                if (!this.fulfillRequirements(testCaCert)) {
                    caCert = this.createRootCACert(nexuHome, api.getAppConfig().getApplicationName(), pki, webServerKeyStoreFile);
                } else {
                    this.createWebServerKeystoreAndDeleteRoot(keyStoreFile, nexuHome, api.getAppConfig().getApplicationName(), webServerKeyStoreFile, pki);
                    caCert = testCaCert;
                }
            }
            catch (IOException | CertificateException e) {
                LOGGER.warn("Exception when trying to determine if certificate fulfills requirements.", e);
                return Arrays.asList(new InitializationMessage(InitializationMessage.MessageType.WARNING, resourceBundle.getString("warn.install.cert.title"), MessageFormat.format(resourceBundle.getString("warn.install.cert.header"), api.getAppConfig().getApplicationName(), "requirements"), baseResourceBundle.getString("contact.application.provider")));
            }
        }
        return this.installCaCert(api, caCert, resourceBundle, baseResourceBundle);
    }

    /*
     * Exception decompiling
     */
    private boolean fulfillRequirements(File caCert) throws IOException, CertificateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    File createRootCACert(File nexuHome, String applicationName, PKIManager pki, File webServerKeyStoreFile) {
        try {
            File keyStoreFile = new File(nexuHome, "keystore.jks");
            LOGGER.info("Creating keystore " + keyStoreFile.getAbsolutePath());
            KeyPair pair = pki.createKeyPair();
            Calendar cal = Calendar.getInstance();
            Date notBefore = cal.getTime();
            cal.add(1, 10);
            Date notAfter = cal.getTime();
            X509Certificate cert = pki.generateRootSelfSignedCertificate(pair.getPrivate(), pair.getPublic(), notBefore, notAfter, applicationName);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            try (FileOutputStream output = new FileOutputStream(keyStoreFile);){
                keyStore.setKeyEntry("localhost", pair.getPrivate(), "password".toCharArray(), new Certificate[]{cert});
                keyStore.store(output, "password".toCharArray());
            }
            File caCert = new File(nexuHome, applicationName + "-" + notBefore.getTime() + ".crt");
            try (FileOutputStream caOutput = new FileOutputStream(caCert);){
                caOutput.write(cert.getEncoded());
            }
            this.createWebServerKeystoreAndDeleteRoot(keyStoreFile, nexuHome, applicationName, webServerKeyStoreFile, pki);
            return caCert;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create keystore", e);
        }
    }

    private void createWebServerKeystoreAndDeleteRoot(File keyStoreFile, File nexuHome, String applicationName, File webServerKeyStoreFile, PKIManager pki) {
        try {
            X509Certificate rootCert;
            Throwable throwable;
            KeyStore rootKS = KeyStore.getInstance("JKS");
            try (FileInputStream fis = new FileInputStream(keyStoreFile);){
                throwable = null;
                try (BufferedInputStream bis = new BufferedInputStream(fis);){
                    rootKS.load(bis, "password".toCharArray());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            PrivateKey rootPrivateKey = (PrivateKey)rootKS.getKey("localhost", "password".toCharArray());
            throwable = null;
            try (FileInputStream fis = new FileInputStream(pki.getRootCertificate(nexuHome, applicationName));
                 BufferedInputStream bis2 = new BufferedInputStream(fis);){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                rootCert = (X509Certificate)cf.generateCertificate(bis2);
            }
            catch (Throwable bis2) {
                throwable = bis2;
                throw bis2;
            }
            KeyPair keyPair = pki.createKeyPair();
            Calendar cal = Calendar.getInstance();
            Date notBefore = cal.getTime();
            cal.add(1, 10);
            long notAfterMs = cal.getTime().after(rootCert.getNotAfter()) ? rootCert.getNotAfter().getTime() - 1L : cal.getTime().getTime();
            Date notAfter = new Date(notAfterMs);
            X509Certificate cert = pki.generateCertificateForWebServer(rootPrivateKey, rootCert, keyPair.getPrivate(), keyPair.getPublic(), notBefore, notAfter, applicationName);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            try (FileOutputStream output = new FileOutputStream(webServerKeyStoreFile);){
                keyStore.setKeyEntry("localhost", keyPair.getPrivate(), "password".toCharArray(), new Certificate[]{cert, rootCert});
                keyStore.store(output, "password".toCharArray());
            }
            Files.delete(keyStoreFile.toPath());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException("Cannot create keystore", e);
        }
    }

    private List<InitializationMessage> installCaCert(NexuAPI api, File caCert, ResourceBundle resourceBundle, ResourceBundle baseResourceBundle) {
        ArrayList<InitializationMessage> messages = new ArrayList<InitializationMessage>();
        EnvironmentInfo envInfo = EnvironmentInfo.buildFromSystemProperties(System.getProperties());
        switch (envInfo.getOs()) {
            case WINDOWS: {
                messages.addAll(this.installCaCertInFirefoxForWindows(api, caCert, resourceBundle, baseResourceBundle));
                messages.addAll(this.installCaCertInWindowsStore(api, caCert, resourceBundle, baseResourceBundle));
                break;
            }
            case MACOSX: {
                messages.addAll(this.installCaCertInFirefoxForMac(api, caCert, resourceBundle, baseResourceBundle));
                messages.addAll(this.installCaCertInMacUserKeychain(api, caCert, resourceBundle, baseResourceBundle));
                break;
            }
            case LINUX: {
                messages.addAll(this.installCaCertInLinuxFFChromeStores(api, caCert, resourceBundle, baseResourceBundle));
                break;
            }
            case NOT_RECOGNIZED: {
                LOGGER.warn("Automatic installation of CA certficate is not yet supported for NOT_RECOGNIZED.");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled value: " + (Object)((Object)envInfo.getOs()));
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InitializationMessage> installCaCertInFirefoxForWindows(NexuAPI api, File caCert, ResourceBundle resourceBundle, ResourceBundle baseResourceBundle) {
        Path tempDirPath = null;
        try {
            tempDirPath = Files.createTempDirectory("NexU-Firefox-Add_certs", new FileAttribute[0]);
            File tempDirFile = tempDirPath.toFile();
            File zipFile = new File(tempDirFile, "firefox_add-certs-nowina-1.2.zip");
            FileUtils.copyURLToFile(this.getClass().getResource("/firefox_add-certs-nowina-1.2.zip"), zipFile);
            new ZipFile(zipFile).extractAll(tempDirPath.toString());
            File unzippedFolder = new File(tempDirFile.getAbsolutePath() + File.separator + "firefox_add-certs-nowina-1.2");
            File caCertDestDir = new File(unzippedFolder, "cacert");
            FileUtils.copyFile(caCert, new File(caCertDestDir, caCert.getName()));
            ProcessBuilder pb = new ProcessBuilder(unzippedFolder + File.separator + "add-certs.cmd");
            pb.redirectErrorStream(true);
            Process p = pb.start();
            if (!p.waitFor(180L, TimeUnit.SECONDS)) {
                throw new NexuException("Timeout occurred when trying to install CA certificate in Firefox");
            }
            if (p.exitValue() == -1) {
                LOGGER.info("Mozilla Firefox not installed.");
            } else if (p.exitValue() != 0) {
                String output = IOUtils.toString(p.getInputStream(), Charset.defaultCharset());
                throw new NexuException("Batch script returned " + p.exitValue() + " when trying to install CA certificate in Firefox. Output: " + output);
            }
            List<InitializationMessage> list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.warn("Exception when trying to install certificate in Firefox", e);
            List<InitializationMessage> list = Arrays.asList(new InitializationMessage(InitializationMessage.MessageType.WARNING, resourceBundle.getString("warn.install.cert.title"), MessageFormat.format(resourceBundle.getString("warn.install.cert.header"), api.getAppConfig().getApplicationName(), "FireFox"), baseResourceBundle.getString("contact.application.provider")));
            return list;
        }
        finally {
            if (tempDirPath != null) {
                try {
                    FileUtils.deleteDirectory(tempDirPath.toFile());
                }
                catch (IOException e) {
                    LOGGER.error("IOException when deleting " + tempDirPath.toString() + ": " + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InitializationMessage> installCaCertInFirefoxForMac(NexuAPI api, File caCert, ResourceBundle resourceBundle, ResourceBundle baseResourceBundle) {
        Path tempDirPath = null;
        try {
            tempDirPath = Files.createTempDirectory("NexU-Firefox-Add_certs", new FileAttribute[0]);
            File tempDirFile = tempDirPath.toFile();
            File zipFile = new File(tempDirFile, "firefox_add-certs-mac-1.1.zip");
            FileUtils.copyURLToFile(this.getClass().getResource("/firefox_add-certs-mac-1.1.zip"), zipFile);
            new ZipFile(zipFile).extractAll(tempDirPath.toString());
            ProcessBuilder pb = new ProcessBuilder("/bin/bash", "add_certs.sh", caCert.getName().substring(0, caCert.getName().lastIndexOf(46)), caCert.getAbsolutePath());
            pb.directory(new File(tempDirFile.getAbsolutePath() + File.separator + "firefox_add-certs-mac-1.1" + File.separator + "bin"));
            pb.redirectErrorStream(true);
            Process p = pb.start();
            if (!p.waitFor(180L, TimeUnit.SECONDS)) {
                throw new NexuException("Timeout occurred when trying to install CA certificate in Firefox");
            }
            if (p.exitValue() != 0) {
                String output = IOUtils.toString(p.getInputStream(), Charset.defaultCharset());
                throw new NexuException("Batch script returned " + p.exitValue() + " when trying to install CA certificate in Firefox. Output: " + output);
            }
            List<InitializationMessage> list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.warn("Exception when trying to install certificate in Firefox", e);
            List<InitializationMessage> list = Arrays.asList(new InitializationMessage(InitializationMessage.MessageType.WARNING, resourceBundle.getString("warn.install.cert.title"), MessageFormat.format(resourceBundle.getString("warn.install.cert.header"), api.getAppConfig().getApplicationName(), "FireFox"), baseResourceBundle.getString("contact.application.provider")));
            return list;
        }
        finally {
            if (tempDirPath != null) {
                try {
                    FileUtils.deleteDirectory(tempDirPath.toFile());
                }
                catch (IOException e) {
                    LOGGER.error("IOException when deleting " + tempDirPath.toString() + ": " + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private List<InitializationMessage> installCaCertInWindowsStore(NexuAPI api, File caCert, ResourceBundle resourceBundle, ResourceBundle baseResourceBundle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InitializationMessage> installCaCertInMacUserKeychain(NexuAPI api, File caCert, ResourceBundle resourceBundle, ResourceBundle baseResourceBundle) {
        Path tempFilePath = null;
        try {
            tempFilePath = Files.createTempFile("mac_user_keychain_add-certs", "sh", new FileAttribute[0]);
            File tempFile = tempFilePath.toFile();
            FileUtils.copyURLToFile(this.getClass().getResource("/mac_user_keychain_add-certs.sh"), tempFile);
            ProcessBuilder pb = new ProcessBuilder("/bin/bash", tempFile.getAbsolutePath(), caCert.getAbsolutePath());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            if (!p.waitFor(180L, TimeUnit.SECONDS)) {
                throw new NexuException("Timeout occurred when trying to install CA certificate in Mac user keychain");
            }
            if (p.exitValue() != 0) {
                String output = IOUtils.toString(p.getInputStream(), Charset.defaultCharset());
                throw new NexuException("Batch script returned " + p.exitValue() + " when trying to install CA certificate in Mac user keychain. Output: " + output);
            }
            List<InitializationMessage> list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.warn("Exception when trying to install certificate in Mac user keychain", e);
            List<InitializationMessage> list = Arrays.asList(new InitializationMessage(InitializationMessage.MessageType.WARNING, resourceBundle.getString("warn.install.cert.title"), MessageFormat.format(resourceBundle.getString("warn.install.cert.header"), api.getAppConfig().getApplicationName(), "Mac user keychain"), baseResourceBundle.getString("contact.application.provider")));
            return list;
        }
        finally {
            if (tempFilePath != null) {
                try {
                    Files.delete(tempFilePath);
                }
                catch (IOException e) {
                    LOGGER.error("IOException when deleting " + tempFilePath.toString() + ": " + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InitializationMessage> installCaCertInLinuxFFChromeStores(NexuAPI api, File caCert, ResourceBundle resourceBundle, ResourceBundle baseResourceBundle) {
        Path tempFilePath = null;
        try {
            tempFilePath = Files.createTempFile("linux_add-certs.sh", "sh", new FileAttribute[0]);
            File tempFile = tempFilePath.toFile();
            FileUtils.copyURLToFile(this.getClass().getResource("/linux_add-certs.sh"), tempFile);
            ProcessBuilder pb = new ProcessBuilder("/bin/bash", tempFile.getAbsolutePath(), caCert.getName().substring(0, caCert.getName().lastIndexOf(46)), caCert.getAbsolutePath());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            if (!p.waitFor(180L, TimeUnit.SECONDS)) {
                throw new NexuException("Timeout occurred when trying to install CA certificate in Linux FF and Chrome/Chromium stores.");
            }
            if (p.exitValue() != 0) {
                String output = IOUtils.toString(p.getInputStream(), Charset.defaultCharset());
                throw new NexuException("Batch script returned " + p.exitValue() + " when trying to install CA certificate in Linux FF and Chrome/Chromium stores. Output: " + output);
            }
            List<InitializationMessage> list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.warn("Exception when trying to install certificate in Linux FF and Chrome/Chromium stores", e);
            List<InitializationMessage> list = Arrays.asList(new InitializationMessage(InitializationMessage.MessageType.WARNING, resourceBundle.getString("warn.install.cert.title"), MessageFormat.format(resourceBundle.getString("warn.install.cert.header"), api.getAppConfig().getApplicationName(), "Linux Firefox & Chrome/Chromium stores"), baseResourceBundle.getString("contact.application.provider")));
            return list;
        }
        finally {
            if (tempFilePath != null) {
                try {
                    Files.delete(tempFilePath);
                }
                catch (IOException e) {
                    LOGGER.error("IOException when deleting " + tempFilePath.toString() + ": " + e.getMessage(), e);
                }
            }
        }
    }
}

