/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.generic;

import at.gv.egiz.smcc.CancelledException;
import at.gv.egiz.smcc.CardNotSupportedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardFactory;
import at.gv.egiz.smcc.TimeoutException;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.token.mocca.MOCCASignatureTokenConnection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import lu.nowina.nexu.CancelledOperationException;
import lu.nowina.nexu.api.DetectedCard;
import lu.nowina.nexu.api.NexuAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MOCCASignatureTokenConnectionAdapter
implements SignatureTokenConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MOCCASignatureTokenConnectionAdapter.class.getSimpleName());
    private final MOCCASignatureTokenConnection adapted;
    private final NexuAPI api;
    private final DetectedCard card;

    public MOCCASignatureTokenConnectionAdapter(MOCCASignatureTokenConnection adapted, NexuAPI api, DetectedCard card) {
        this.adapted = adapted;
        this.api = api;
        this.card = card;
    }

    @Override
    public void close() {
        this.adapted.close();
    }

    private List<SignatureCard> getSignatureCard() {
        Card card;
        SignatureCardFactory factory = SignatureCardFactory.getInstance();
        CardTerminal cardTerminal = this.api.getCardTerminal(this.card);
        try {
            card = cardTerminal.connect("*");
        }
        catch (CardException e) {
            card = null;
            LOGGER.debug("Failed to connect to card.", e);
        }
        try {
            ArrayList<SignatureCard> result = new ArrayList<SignatureCard>(1);
            result.add(factory.createSignatureCard(card, cardTerminal));
            return result;
        }
        catch (CardNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void setSignatureCard() {
        Field field;
        try {
            field = MOCCASignatureTokenConnection.class.getDeclaredField("_signatureCards");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        field.setAccessible(true);
        try {
            field.set(this.adapted, this.getSignatureCard());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        try {
            this.setSignatureCard();
            return this.adapted.getKeys();
        }
        catch (Exception e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (t instanceof CancelledException || t instanceof TimeoutException) {
                    throw new CancelledOperationException(e);
                }
                if (!(t instanceof CancelledOperationException)) continue;
                throw (CancelledOperationException)t;
            }
            throw e;
        }
    }

    @Override
    @Deprecated
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        return this.sign(toBeSigned, digestAlgorithm, null, keyEntry);
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf, DSSPrivateKeyEntry keyEntry) throws DSSException {
        try {
            this.setSignatureCard();
            return this.adapted.sign(toBeSigned, digestAlgorithm, mgf, keyEntry);
        }
        catch (Exception e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (t instanceof CancelledException || t instanceof TimeoutException) {
                    throw new CancelledOperationException(e);
                }
                if (!(t instanceof CancelledOperationException)) continue;
                throw (CancelledOperationException)t;
            }
            throw e;
        }
    }
}

