/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.generic;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import lu.nowina.nexu.ProxyConfigurer;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.plugin.HttpStatus;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDataLoader {
    private static final Logger logger = LoggerFactory.getLogger(HttpDataLoader.class.getName());
    private final ProxyConfigurer proxyConfigurer;
    private final String applicationVersion;
    private final boolean sendAnonymousInfoToProxy;

    public HttpDataLoader(ProxyConfigurer proxyConfigurer, String applicationVersion, boolean sendAnonymousInfoToProxy) {
        this.proxyConfigurer = proxyConfigurer;
        this.applicationVersion = applicationVersion;
        this.sendAnonymousInfoToProxy = sendAnonymousInfoToProxy;
    }

    public byte[] fetchDatabase(String databaseUrl) throws IOException {
        return this.performGetRequest(databaseUrl);
    }

    public byte[] fetchNexuInfo(String infoUrl) throws IOException {
        return this.performGetRequest(infoUrl);
    }

    private byte[] performGetRequest(String requestUrl) throws IOException {
        HttpGet get = new HttpGet(requestUrl);
        if (this.sendAnonymousInfoToProxy) {
            EnvironmentInfo info = EnvironmentInfo.buildFromSystemProperties(System.getProperties());
            URI uri = null;
            try {
                uri = new URIBuilder(get.getURI()).addParameter("application.version", this.applicationVersion).addParameter("jre.vendor", info.getJreVendor().toString()).addParameter("os.name", info.getOsName()).addParameter("os.arch", info.getOsArch()).addParameter("os.version", info.getOsVersion()).build();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            get.setURI(uri);
        }
        this.proxyConfigurer.setupProxy(get);
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(this.proxyConfigurer.getProxyCredentialsProvider(get.getConfig().getProxy())).build();
        HttpResponse response = client.execute(get);
        if (HttpStatus.OK.getHttpCode() != response.getStatusLine().getStatusCode()) {
            logger.warn("Cannot perform GET request at " + requestUrl + ", status code = " + response.getStatusLine().getStatusCode());
            return null;
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        return ((String)responseHandler.handleResponse(response)).getBytes();
    }
}

