/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.generic;

import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.MSCAPISignatureToken;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.token.mocca.MOCCASignatureTokenConnection;
import java.io.File;
import java.util.List;
import lu.nowina.nexu.api.AbstractCardProductAdapter;
import lu.nowina.nexu.api.CertificateFilter;
import lu.nowina.nexu.api.CertificateFilterHelper;
import lu.nowina.nexu.api.DetectedCard;
import lu.nowina.nexu.api.GetIdentityInfoResponse;
import lu.nowina.nexu.api.MessageDisplayCallback;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.ScAPI;
import lu.nowina.nexu.generic.ConnectionInfo;
import lu.nowina.nexu.generic.MOCCASignatureTokenConnectionAdapter;
import lu.nowina.nexu.generic.Pkcs11SignatureTokenAdapter;
import lu.nowina.nexu.generic.SCInfo;

public class GenericCardAdapter
extends AbstractCardProductAdapter {
    private final SCInfo info;

    public GenericCardAdapter(SCInfo info) {
        this.info = info;
    }

    @Override
    protected boolean accept(DetectedCard card) {
        return this.info.getAtr().equals(card.getAtr());
    }

    @Override
    protected String getLabel(NexuAPI api, DetectedCard card, PasswordInputCallback callback) {
        return card.getLabel();
    }

    @Override
    protected String getLabel(NexuAPI api, DetectedCard card, PasswordInputCallback callback, MessageDisplayCallback messageCallback) {
        throw new IllegalStateException("This product adapter does not support message display callback.");
    }

    @Override
    protected boolean supportMessageDisplayCallback(DetectedCard card) {
        return false;
    }

    @Override
    protected SignatureTokenConnection connect(NexuAPI api, DetectedCard card, PasswordInputCallback callback) {
        ConnectionInfo cInfo = this.info.getConnectionInfo(api.getEnvironmentInfo());
        ScAPI scApi = cInfo.getSelectedApi();
        switch (scApi) {
            case MSCAPI: {
                return new MSCAPISignatureToken();
            }
            case PKCS_11: {
                String absolutePath = cInfo.getApiParam();
                return new Pkcs11SignatureTokenAdapter(new File(absolutePath), callback, card.getTerminalIndex());
            }
            case MOCCA: {
                return new MOCCASignatureTokenConnectionAdapter(new MOCCASignatureTokenConnection(callback), api, card);
            }
        }
        throw new RuntimeException("API not supported");
    }

    @Override
    protected SignatureTokenConnection connect(NexuAPI api, DetectedCard card, PasswordInputCallback callback, MessageDisplayCallback messageCallback) {
        throw new IllegalStateException("This product adapter does not support message display callback.");
    }

    @Override
    protected boolean canReturnIdentityInfo(DetectedCard card) {
        return false;
    }

    @Override
    public GetIdentityInfoResponse getIdentityInfo(SignatureTokenConnection token) {
        throw new IllegalStateException("This card adapter cannot return identity information.");
    }

    @Override
    protected boolean supportCertificateFilter(DetectedCard card) {
        return true;
    }

    @Override
    protected boolean canReturnSuportedDigestAlgorithms(DetectedCard card) {
        return false;
    }

    @Override
    protected List<DigestAlgorithm> getSupportedDigestAlgorithms(DetectedCard card) {
        throw new IllegalStateException("This card adapter cannot return list of supported digest algorithms.");
    }

    @Override
    protected DigestAlgorithm getPreferredDigestAlgorithm(DetectedCard card) {
        throw new IllegalStateException("This card adapter cannot return list of supported digest algorithms.");
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys(SignatureTokenConnection token, CertificateFilter certificateFilter) {
        return new CertificateFilterHelper().filterKeys(token, certificateFilter);
    }
}

