/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow.operation;

import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import lu.nowina.nexu.CancelledOperationException;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.Operation;
import lu.nowina.nexu.api.flow.OperationResult;

public class SignOperation
implements Operation<SignatureValue> {
    private SignatureTokenConnection token;
    private ToBeSigned toBeSigned;
    private DigestAlgorithm digestAlgorithm;
    private DSSPrivateKeyEntry key;

    @Override
    public void setParams(Object ... params) {
        try {
            this.token = (SignatureTokenConnection)params[0];
            this.toBeSigned = (ToBeSigned)params[1];
            this.digestAlgorithm = (DigestAlgorithm)((Object)params[2]);
            this.key = (DSSPrivateKeyEntry)params[3];
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Expected parameters: SignatureTokenConnection, ToBeSigned, DigestAlgorithm, DSSPrivateKeyEntry");
        }
    }

    @Override
    public OperationResult<SignatureValue> perform() {
        try {
            return new OperationResult<SignatureValue>(this.token.sign(this.toBeSigned, this.digestAlgorithm, this.key));
        }
        catch (CancelledOperationException e) {
            return new OperationResult<SignatureValue>(BasicOperationStatus.USER_CANCEL);
        }
    }
}

