/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow;

import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.util.Map;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.api.Execution;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.SignatureRequest;
import lu.nowina.nexu.api.SignatureResponse;
import lu.nowina.nexu.api.TokenId;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.flow.AbstractCoreFlow;
import lu.nowina.nexu.flow.operation.AdvancedCreationFeedbackOperation;
import lu.nowina.nexu.flow.operation.GetTokenConnectionOperation;
import lu.nowina.nexu.flow.operation.GetTokenOperation;
import lu.nowina.nexu.flow.operation.SelectPrivateKeyOperation;
import lu.nowina.nexu.flow.operation.SignOperation;
import lu.nowina.nexu.flow.operation.TokenOperationResultKey;
import lu.nowina.nexu.view.core.UIDisplay;
import lu.nowina.nexu.view.core.UIOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignatureFlow
extends AbstractCoreFlow<SignatureRequest, SignatureResponse> {
    private static final Logger logger = LoggerFactory.getLogger(SignatureFlow.class.getName());

    public SignatureFlow(UIDisplay display, NexuAPI api) {
        super(display, api);
    }

    @Override
    protected Execution<SignatureResponse> process(NexuAPI api, SignatureRequest req) throws Exception {
        if (req.getToBeSigned() == null || req.getToBeSigned().getBytes() == null) {
            throw new NexuException("ToBeSigned is null");
        }
        if (req.getDigestAlgorithm() == null) {
            throw new NexuException("Digest algorithm expected");
        }
        SignatureTokenConnection token = null;
        try {
            OperationResult getTokenOperationResult = this.getOperationFactory().getOperation(GetTokenOperation.class, api, req.getTokenId()).perform();
            if (getTokenOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) {
                Map map = (Map)getTokenOperationResult.getResult();
                TokenId tokenId = (TokenId)map.get((Object)TokenOperationResultKey.TOKEN_ID);
                OperationResult getTokenConnectionOperationResult = this.getOperationFactory().getOperation(GetTokenConnectionOperation.class, api, tokenId).perform();
                if (getTokenConnectionOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) {
                    token = (SignatureTokenConnection)getTokenConnectionOperationResult.getResult();
                    logger.info("Token " + token);
                    Product product = (Product)map.get((Object)TokenOperationResultKey.SELECTED_PRODUCT);
                    ProductAdapter productAdapter = (ProductAdapter)map.get((Object)TokenOperationResultKey.SELECTED_PRODUCT_ADAPTER);
                    OperationResult selectPrivateKeyOperationResult = this.getOperationFactory().getOperation(SelectPrivateKeyOperation.class, token, api, product, productAdapter, null, req.getKeyId()).perform();
                    if (selectPrivateKeyOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) {
                        DSSPrivateKeyEntry key = (DSSPrivateKeyEntry)selectPrivateKeyOperationResult.getResult();
                        logger.info("Key " + key + " " + key.getCertificate().getCertificate().getSubjectDN() + " from " + key.getCertificate().getCertificate().getIssuerDN());
                        OperationResult signOperationResult = this.getOperationFactory().getOperation(SignOperation.class, new Object[]{token, req.getToBeSigned(), req.getDigestAlgorithm(), key}).perform();
                        if (signOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) {
                            SignatureValue value = (SignatureValue)signOperationResult.getResult();
                            logger.info("Signature performed " + value);
                            if (((Boolean)map.get((Object)TokenOperationResultKey.ADVANCED_CREATION)).booleanValue()) {
                                this.getOperationFactory().getOperation(AdvancedCreationFeedbackOperation.class, api, map).perform();
                            }
                            if (api.getAppConfig().isEnablePopUps() && api.getAppConfig().isEnableInformativePopUps()) {
                                this.getOperationFactory().getOperation(UIOperation.class, "/fxml/message.fxml", "signature.flow.finished", api.getAppConfig().getApplicationName()).perform();
                            }
                            Execution<SignatureResponse> execution = new Execution<SignatureResponse>(new SignatureResponse(value, key.getCertificate(), key.getCertificateChain()));
                            return execution;
                        }
                        Execution<SignatureResponse> execution = this.handleErrorOperationResult(signOperationResult);
                        return execution;
                    }
                    if (api.getAppConfig().isEnablePopUps()) {
                        this.getOperationFactory().getOperation(UIOperation.class, "/fxml/message.fxml", "signature.flow.no.key.selected", api.getAppConfig().getApplicationName()).perform();
                    }
                    Execution<SignatureResponse> execution = this.handleErrorOperationResult(selectPrivateKeyOperationResult);
                    return execution;
                }
                if (api.getAppConfig().isEnablePopUps()) {
                    this.getOperationFactory().getOperation(UIOperation.class, "/fxml/message.fxml", "signature.flow.bad.token", api.getAppConfig().getApplicationName()).perform();
                }
                Execution<SignatureResponse> execution = this.handleErrorOperationResult(getTokenConnectionOperationResult);
                return execution;
            }
            Execution<SignatureResponse> execution = this.handleErrorOperationResult(getTokenOperationResult);
            return execution;
        }
        catch (Exception e) {
            logger.error("Flow error", e);
            throw this.handleException(e);
        }
        finally {
            if (token != null) {
                try {
                    token.close();
                }
                catch (Exception e) {
                    logger.error("Exception when closing token", e);
                }
            }
        }
    }
}

