/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow;

import lu.nowina.nexu.api.Execution;
import lu.nowina.nexu.api.Feedback;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.flow.OperationFactory;
import lu.nowina.nexu.view.core.UIDisplay;
import lu.nowina.nexu.view.core.UIOperation;

public abstract class Flow<I, O> {
    private UIDisplay display;
    private OperationFactory operationFactory;
    private NexuAPI api;

    public Flow(UIDisplay display, NexuAPI api) {
        if (display == null) {
            throw new IllegalArgumentException("display cannot be null");
        }
        this.display = display;
        this.api = api;
    }

    public final void setOperationFactory(OperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    protected final OperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Execution<O> execute(NexuAPI api, I input) throws Exception {
        try {
            Execution<O> out;
            Execution<O> execution = out = this.process(api, input);
            return execution;
        }
        finally {
            this.display.close(true);
        }
    }

    protected abstract Execution<O> process(NexuAPI var1, I var2) throws Exception;

    protected final UIDisplay getDisplay() {
        return this.display;
    }

    protected Exception handleException(Exception e) {
        if (this.api.getAppConfig().isEnablePopUps()) {
            if (this.api.getAppConfig().isEnableIncidentReport()) {
                Feedback feedback = new Feedback(e);
                this.getOperationFactory().getOperation(UIOperation.class, "/fxml/provide-feedback.fxml", new Object[]{feedback, this.api.getAppConfig().getServerUrl(), this.api.getAppConfig().getApplicationVersion(), this.api.getAppConfig().getApplicationName(), this.api.getAppConfig()}).perform();
            } else {
                this.getOperationFactory().getOperation(UIOperation.class, "/fxml/message.fxml", new Object[]{"exception.failure.message", this.api.getAppConfig().getApplicationName()}).perform();
            }
        }
        return e;
    }
}

