/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.api;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="osName")
@XmlEnum
public enum OS {
    MACOSX("DYLIB", "*.dylib"),
    LINUX("SO", "*.so"),
    WINDOWS("DLL", "*.dll"),
    NOT_RECOGNIZED("", "");

    private static final Logger LOGGER;
    private final String nativeLibraryFileExtensionDescription;
    private final String nativeLibraryFileExtension;

    public static OS forOSName(String osName) {
        if (osName.startsWith("Mac")) {
            return MACOSX;
        }
        if (osName.toLowerCase().contains("windows")) {
            return WINDOWS;
        }
        if (osName.toLowerCase().contains("linux")) {
            return LINUX;
        }
        LOGGER.warn("OS name not recognized " + osName);
        return NOT_RECOGNIZED;
    }

    private OS(String nativeLibraryFileExtensionDescription, String nativeLibraryFileExtension) {
        this.nativeLibraryFileExtensionDescription = nativeLibraryFileExtensionDescription;
        this.nativeLibraryFileExtension = nativeLibraryFileExtension;
    }

    public String getNativeLibraryFileExtensionDescription() {
        return this.nativeLibraryFileExtensionDescription;
    }

    public String getNativeLibraryFileExtension() {
        return this.nativeLibraryFileExtension;
    }

    static {
        LOGGER = LoggerFactory.getLogger(OS.class);
    }
}

