/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.api;

import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import lu.nowina.nexu.api.Arch;
import lu.nowina.nexu.api.JREVendor;
import lu.nowina.nexu.api.OS;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="environment", propOrder={"jreVendor", "osName", "osArch", "osVersion", "arch", "os"})
public class EnvironmentInfo {
    private static final String OS_VERSION = "os.version";
    private static final String OS_NAME = "os.name";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String OS_ARCH = "os.arch";
    private JREVendor jreVendor;
    private String osName;
    private String osArch;
    private String osVersion;
    private Arch arch;
    private OS os;

    public static EnvironmentInfo buildFromSystemProperties(Properties systemProperties) {
        EnvironmentInfo info = new EnvironmentInfo();
        String osArch = systemProperties.getProperty(OS_ARCH);
        info.setOsArch(osArch);
        info.setArch(Arch.forOSArch(osArch));
        info.setJreVendor(JREVendor.forJREVendor(System.getProperty(JAVA_VENDOR)));
        String osName = systemProperties.getProperty(OS_NAME);
        info.setOsName(osName);
        info.setOs(OS.forOSName(osName));
        String osVersion = systemProperties.getProperty(OS_VERSION);
        info.setOsVersion(osVersion);
        return info;
    }

    public boolean matches(EnvironmentInfo env) {
        if (this.os != null && this.os != env.getOs()) {
            return false;
        }
        return this.arch == null || this.arch == env.getArch();
    }

    public JREVendor getJreVendor() {
        return this.jreVendor;
    }

    public void setJreVendor(JREVendor jreVendor) {
        this.jreVendor = jreVendor;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public Arch getArch() {
        return this.arch;
    }

    public void setArch(Arch arch) {
        this.arch = arch;
    }

    public OS getOs() {
        return this.os;
    }

    public void setOs(OS os) {
        this.os = os;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }
}

