/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.api;

import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.tsl.KeyUsageBit;
import java.util.ArrayList;
import java.util.List;
import lu.nowina.nexu.api.CertificateFilter;

public class CertificateFilterHelper {
    public List<DSSPrivateKeyEntry> filterKeys(SignatureTokenConnection token, CertificateFilter filter) {
        if (filter.getNonRepudiationBit().booleanValue()) {
            ArrayList<DSSPrivateKeyEntry> filteredList = new ArrayList<DSSPrivateKeyEntry>();
            for (DSSPrivateKeyEntry entry : token.getKeys()) {
                if (!entry.getCertificate().checkKeyUsage(KeyUsageBit.nonRepudiation)) continue;
                filteredList.add(entry);
            }
            return filteredList;
        }
        return token.getKeys();
    }
}

