/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.api;

import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import lu.nowina.nexu.api.DetectedCard;
import lu.nowina.nexu.api.MessageDisplayCallback;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.NexuPasswordInputCallback;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.SystrayMenuItem;
import lu.nowina.nexu.api.flow.FutureOperationInvocation;
import lu.nowina.nexu.api.flow.NoOpFutureOperationInvocation;

public abstract class AbstractCardProductAdapter
implements ProductAdapter {
    private void setPasswordPrompt(PasswordInputCallback callback) {
        if (callback instanceof NexuPasswordInputCallback) {
            ResourceBundle resources = ResourceBundle.getBundle("bundles/nexu-api");
            ((NexuPasswordInputCallback)callback).setPasswordPrompt(resources.getString("card.product.adapter.password.prompt"));
        }
    }

    @Override
    public final boolean accept(Product product) {
        return product instanceof DetectedCard && this.accept((DetectedCard)product);
    }

    protected abstract boolean accept(DetectedCard var1);

    @Override
    public String getLabel(NexuAPI api, Product product, PasswordInputCallback callback) {
        this.setPasswordPrompt(callback);
        return this.getLabel(api, (DetectedCard)product, callback);
    }

    protected abstract String getLabel(NexuAPI var1, DetectedCard var2, PasswordInputCallback var3);

    @Override
    public String getLabel(NexuAPI api, Product product, PasswordInputCallback callback, MessageDisplayCallback messageCallback) {
        this.setPasswordPrompt(callback);
        return this.getLabel(api, (DetectedCard)product, callback, messageCallback);
    }

    protected abstract String getLabel(NexuAPI var1, DetectedCard var2, PasswordInputCallback var3, MessageDisplayCallback var4);

    @Override
    public final boolean supportMessageDisplayCallback(Product product) {
        return this.supportMessageDisplayCallback((DetectedCard)product);
    }

    protected abstract boolean supportMessageDisplayCallback(DetectedCard var1);

    @Override
    public final SignatureTokenConnection connect(NexuAPI api, Product product, PasswordInputCallback callback) {
        this.setPasswordPrompt(callback);
        return this.connect(api, (DetectedCard)product, callback);
    }

    protected abstract SignatureTokenConnection connect(NexuAPI var1, DetectedCard var2, PasswordInputCallback var3);

    @Override
    public final SignatureTokenConnection connect(NexuAPI api, Product product, PasswordInputCallback callback, MessageDisplayCallback messageCallback) {
        this.setPasswordPrompt(callback);
        return this.connect(api, (DetectedCard)product, callback, messageCallback);
    }

    protected abstract SignatureTokenConnection connect(NexuAPI var1, DetectedCard var2, PasswordInputCallback var3, MessageDisplayCallback var4);

    @Override
    public final boolean canReturnIdentityInfo(Product product) {
        return product instanceof DetectedCard && this.canReturnIdentityInfo((DetectedCard)product);
    }

    protected abstract boolean canReturnIdentityInfo(DetectedCard var1);

    @Override
    public final boolean supportCertificateFilter(Product product) {
        return product instanceof DetectedCard && this.supportCertificateFilter((DetectedCard)product);
    }

    protected abstract boolean supportCertificateFilter(DetectedCard var1);

    @Override
    public final boolean canReturnSuportedDigestAlgorithms(Product product) {
        return product instanceof DetectedCard && this.canReturnSuportedDigestAlgorithms((DetectedCard)product);
    }

    protected abstract boolean canReturnSuportedDigestAlgorithms(DetectedCard var1);

    @Override
    public final List<DigestAlgorithm> getSupportedDigestAlgorithms(Product product) {
        return this.getSupportedDigestAlgorithms((DetectedCard)product);
    }

    protected abstract List<DigestAlgorithm> getSupportedDigestAlgorithms(DetectedCard var1);

    @Override
    public final DigestAlgorithm getPreferredDigestAlgorithm(Product product) {
        return this.getPreferredDigestAlgorithm((DetectedCard)product);
    }

    protected abstract DigestAlgorithm getPreferredDigestAlgorithm(DetectedCard var1);

    @Override
    public final FutureOperationInvocation<Product> getConfigurationOperation(NexuAPI api, Product product) {
        return this.getConfigurationOperation(api, (DetectedCard)product);
    }

    protected FutureOperationInvocation<Product> getConfigurationOperation(NexuAPI api, DetectedCard card) {
        return new NoOpFutureOperationInvocation<Product>(card);
    }

    @Override
    public final FutureOperationInvocation<Boolean> getSaveOperation(NexuAPI api, Product product) {
        return this.getSaveOperation(api, (DetectedCard)product);
    }

    protected FutureOperationInvocation<Boolean> getSaveOperation(NexuAPI api, DetectedCard card) {
        return new NoOpFutureOperationInvocation<Boolean>(true);
    }

    @Override
    public SystrayMenuItem getExtensionSystrayMenuItem() {
        return null;
    }

    public List<Product> detectProducts() {
        return Collections.emptyList();
    }
}

