/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import eu.europa.esig.dss.token.PasswordInputCallback;
import java.io.File;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import lu.nowina.nexu.CancelledOperationException;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.NexuLauncher;
import lu.nowina.nexu.api.MessageDisplayCallback;
import lu.nowina.nexu.api.NexuPasswordInputCallback;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.OperationFactory;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.flow.StageHelper;
import lu.nowina.nexu.view.core.ExtensionFilter;
import lu.nowina.nexu.view.core.NonBlockingUIOperation;
import lu.nowina.nexu.view.core.UIDisplay;
import lu.nowina.nexu.view.core.UIOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneUIDisplay
implements UIDisplay {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneUIDisplay.class.getName());
    private Stage blockingStage = this.createStage(true, null);
    private Stage nonBlockingStage = this.createStage(false, null);
    private UIOperation<?> currentBlockingOperation;
    private OperationFactory operationFactory;

    private void display(Parent panel, boolean blockingOperation) {
        LOGGER.info("Display " + panel + " in display " + this + " from Thread " + Thread.currentThread().getName());
        Platform.runLater(() -> {
            Stage stage = blockingOperation ? this.blockingStage : this.nonBlockingStage;
            LOGGER.info("Display " + panel + " in display " + this + " from Thread " + Thread.currentThread().getName());
            if (!stage.isShowing()) {
                stage = blockingOperation ? (this.blockingStage = this.createStage(true, null)) : (this.nonBlockingStage = this.createStage(false, null));
                LOGGER.info("Loading ui " + panel + " is a new Stage " + stage);
            } else {
                LOGGER.info("Stage still showing, display " + panel);
            }
            Scene scene = new Scene(panel);
            scene.getStylesheets().add((Object)this.getClass().getResource("/styles/nexu.css").toString());
            stage.setScene(scene);
            stage.setTitle(StageHelper.getInstance().getTitle());
            stage.show();
            StageHelper.getInstance().setTitle("", null);
        });
    }

    private Stage createStage(boolean blockingStage, String title) {
        Stage newStage = new Stage();
        newStage.setTitle(title);
        newStage.setAlwaysOnTop(true);
        newStage.setOnCloseRequest(e -> {
            LOGGER.info("Closing stage " + newStage + " from " + Thread.currentThread().getName());
            newStage.hide();
            e.consume();
            if (blockingStage && this.currentBlockingOperation != null) {
                this.currentBlockingOperation.signalUserCancel();
            }
        });
        return newStage;
    }

    @Override
    public void close(boolean blockingOperation) {
        Platform.runLater(() -> {
            Stage oldStage = blockingOperation ? this.blockingStage : this.nonBlockingStage;
            LOGGER.info("Hide stage " + oldStage + " and create new stage");
            if (blockingOperation) {
                this.blockingStage = this.createStage(true, null);
            } else {
                this.nonBlockingStage = this.createStage(false, null);
            }
            oldStage.hide();
        });
    }

    @Override
    public <T> void displayAndWaitUIOperation(UIOperation<T> operation) {
        this.display(operation.getRoot(), true);
        this.waitForUser(operation);
    }

    private <T> void waitForUser(UIOperation<T> operation) {
        try {
            LOGGER.info("Wait on Thread " + Thread.currentThread().getName());
            this.currentBlockingOperation = operation;
            operation.waitEnd();
            this.currentBlockingOperation = null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PasswordInputCallback getPasswordInputCallback() {
        return new FlowPasswordCallback();
    }

    @Override
    public MessageDisplayCallback getMessageDisplayCallback() {
        return new FlowMessageDisplayCallback();
    }

    @Override
    public File displayFileChooser(ExtensionFilter ... extensionFilters) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ResourceBundle.getBundle("bundles/nexu").getString("fileChooser.title.openResourceFile"));
        fileChooser.getExtensionFilters().addAll((Object[])this.toJavaFXExtensionFilters(extensionFilters));
        return fileChooser.showOpenDialog((Window)this.blockingStage);
    }

    private FileChooser.ExtensionFilter[] toJavaFXExtensionFilters(ExtensionFilter ... extensionFilters) {
        FileChooser.ExtensionFilter[] result = new FileChooser.ExtensionFilter[extensionFilters.length];
        int i = 0;
        for (ExtensionFilter extensionFilter : extensionFilters) {
            result[i++] = new FileChooser.ExtensionFilter(extensionFilter.getDescription(), extensionFilter.getExtensions());
        }
        return result;
    }

    public void setOperationFactory(OperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    @Override
    public void display(NonBlockingUIOperation operation) {
        this.display(operation.getRoot(), false);
    }

    private final class FlowMessageDisplayCallback
    implements MessageDisplayCallback {
        private FlowMessageDisplayCallback() {
        }

        @Override
        public void display(MessageDisplayCallback.Message message) {
            if (MessageDisplayCallback.Message.INPUT_PINPAD.equals((Object)message)) {
                StandaloneUIDisplay.this.operationFactory.getOperation(NonBlockingUIOperation.class, "/fxml/message-no-button.fxml", "message.display.callback." + message.name().toLowerCase().replace('_', '.'), NexuLauncher.getConfig().getApplicationName()).perform();
            } else {
                StandaloneUIDisplay.this.operationFactory.getOperation(NonBlockingUIOperation.class, "/fxml/message.fxml", "message.display.callback." + message.name().toLowerCase().replace('_', '.'), NexuLauncher.getConfig().getApplicationName()).perform();
            }
        }

        @Override
        public void dispose() {
            StandaloneUIDisplay.this.close(false);
        }
    }

    private final class FlowPasswordCallback
    implements NexuPasswordInputCallback {
        private String passwordPrompt = null;

        @Override
        public char[] getPassword() {
            LOGGER.info("Request password");
            OperationResult passwordResult = StandaloneUIDisplay.this.operationFactory.getOperation(UIOperation.class, "/fxml/password-input.fxml", this.passwordPrompt, NexuLauncher.getConfig().getApplicationName()).perform();
            if (passwordResult.getStatus().equals(BasicOperationStatus.SUCCESS)) {
                return (char[])passwordResult.getResult();
            }
            if (passwordResult.getStatus().equals(BasicOperationStatus.USER_CANCEL)) {
                throw new CancelledOperationException();
            }
            if (passwordResult.getStatus().equals(BasicOperationStatus.EXCEPTION)) {
                Exception e = passwordResult.getException();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new NexuException(e);
            }
            throw new IllegalArgumentException("Not managed operation status: " + passwordResult.getStatus().getCode());
        }

        @Override
        public void setPasswordPrompt(String passwordPrompt) {
            this.passwordPrompt = passwordPrompt;
        }
    }
}

