/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Properties;
import javafx.application.Application;
import lu.nowina.nexu.NexUApp;
import lu.nowina.nexu.ProxyConfigurer;
import lu.nowina.nexu.UserPreferences;
import lu.nowina.nexu.api.AppConfig;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class NexuLauncher {
    private static final Logger logger = LoggerFactory.getLogger(NexuLauncher.class.getName());
    private static AppConfig config;
    private static Properties props;
    private static ProxyConfigurer proxyConfigurer;

    public static void main(String[] args) throws Exception {
        NexuLauncher launcher = new NexuLauncher();
        launcher.launch(args);
    }

    protected void launch(String[] args) throws IOException {
        props = this.loadProperties();
        this.loadAppConfig(props);
        this.configureLogger(config);
        config.initDefaultProduct(props);
        proxyConfigurer = new ProxyConfigurer(config, new UserPreferences(config.getApplicationName()));
        this.beforeLaunch();
        boolean started = NexuLauncher.checkAlreadyStarted();
        if (!started) {
            NexUApp.launch(this.getApplicationClass(), (String[])args);
        }
    }

    private void configureLogger(AppConfig config) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        ConsoleAppender console = new ConsoleAppender();
        String PATTERN = "%d [%p|%c|%C{1}|%t] %m%n";
        console.setLayout(new PatternLayout(PATTERN));
        console.setThreshold(config.isDebug() ? Level.DEBUG : Level.INFO);
        console.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender(console);
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setName("FileLogger");
        File nexuHome = config.getNexuHome();
        rfa.setFile(new File(nexuHome, "nexu.log").getAbsolutePath());
        rfa.setLayout(new PatternLayout("%d %-5p [%c{1}] %m%n"));
        rfa.setThreshold(config.isDebug() ? Level.DEBUG : Level.INFO);
        rfa.setAppend(true);
        rfa.activateOptions();
        rfa.setMaxFileSize(config.getRollingLogMaxFileSize());
        rfa.setMaxBackupIndex(config.getRollingLogMaxFileNumber());
        org.apache.log4j.Logger.getRootLogger().addAppender(rfa);
        org.apache.log4j.Logger.getLogger("org").setLevel(Level.INFO);
        org.apache.log4j.Logger.getLogger("httpclient").setLevel(Level.INFO);
        org.apache.log4j.Logger.getLogger("freemarker").setLevel(Level.INFO);
        org.apache.log4j.Logger.getLogger("lu.nowina").setLevel(Level.DEBUG);
        org.apache.log4j.Logger.getLogger("java.util.prefs").setLevel(Level.ERROR);
    }

    protected void beforeLaunch() {
    }

    public static AppConfig getConfig() {
        return config;
    }

    public static Properties getProperties() {
        return props;
    }

    public static ProxyConfigurer getProxyConfigurer() {
        return proxyConfigurer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkAlreadyStarted() throws MalformedURLException {
        Iterator<Integer> iterator = config.getBindingPorts().iterator();
        while (iterator.hasNext()) {
            URLConnection connection;
            int port = iterator.next();
            URL url = new URL("http://" + config.getBindingIP() + ":" + port + "/nexu-info");
            try {
                connection = url.openConnection();
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(2000);
            }
            catch (IOException e) {
                logger.warn("IOException when trying to open a connection to " + url + ": " + e.getMessage(), e);
                continue;
            }
            try (InputStream in = connection.getInputStream();){
                String info = IOUtils.toString(in);
                logger.error("NexU already started. Version '" + info + "'");
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                logger.info("No " + url.toString() + " detected, " + e.getMessage());
            }
        }
        return false;
    }

    private final Properties loadProperties() throws IOException {
        Properties props = new Properties();
        this.loadPropertiesFromClasspath(props);
        return props;
    }

    private void loadPropertiesFromClasspath(Properties props) throws IOException {
        InputStream configFile = NexUApp.class.getClassLoader().getResourceAsStream("nexu-config.properties");
        if (configFile != null) {
            props.load(configFile);
        }
    }

    public final void loadAppConfig(Properties props) {
        config = this.createAppConfig();
        config.loadFromProperties(props);
    }

    protected AppConfig createAppConfig() {
        return new AppConfig();
    }

    protected Class<? extends Application> getApplicationClass() {
        return NexUApp.class;
    }
}

