/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.animation.PauseTransition;
import javafx.application.Preloader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import lu.nowina.nexu.NexuLauncher;
import lu.nowina.nexu.api.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexUPreLoader
extends Preloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NexUPreLoader.class);
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle("bundles/nexu");

    private AppConfig getConfig() {
        return NexuLauncher.getConfig();
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification info) {
        if (info instanceof PreloaderMessage) {
            PreloaderMessage preloaderMessage = (PreloaderMessage)info;
            LOGGER.warn("PreLoaderMessage: type = " + preloaderMessage.getMessageType() + ", title = " + preloaderMessage.getTitle() + ", header = " + preloaderMessage.getHeaderText() + ", content = " + preloaderMessage.getContentText());
            Alert alert = new Alert(preloaderMessage.getMessageType());
            alert.setTitle(preloaderMessage.getTitle());
            alert.setHeaderText(preloaderMessage.getHeaderText());
            alert.setContentText(preloaderMessage.getContentText());
            alert.showAndWait();
        } else {
            LOGGER.error("Unknown preloader notification class: " + info.getClass().getName());
        }
    }

    public void start(Stage primaryStage) throws Exception {
        if (this.getConfig().isShowSplashScreen()) {
            ImageView splash = new ImageView(new Image(NexUPreLoader.class.getResourceAsStream("/images/splash.jpg")));
            StackPane background = new StackPane(new Node[]{splash});
            Scene splashScene = new Scene((Parent)background, 600.0, 300.0);
            primaryStage.setScene(splashScene);
            primaryStage.initStyle(StageStyle.UNDECORATED);
            primaryStage.show();
            PauseTransition delay = new PauseTransition(Duration.seconds((double)3.0));
            delay.setOnFinished(event -> primaryStage.close());
            delay.play();
        }
    }

    public boolean handleErrorNotification(Preloader.ErrorNotification info) {
        LOGGER.error("An error has occurred during startup", info.getCause());
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle(this.resourceBundle.getString("preloader.error"));
        alert.setHeaderText(MessageFormat.format(this.resourceBundle.getString("preloader.error.occurred"), this.getConfig().getApplicationName()));
        alert.setContentText(this.resourceBundle.getString("contact.application.provider"));
        alert.showAndWait();
        return true;
    }

    static class PreloaderMessage
    implements Preloader.PreloaderNotification {
        private final Alert.AlertType messageType;
        private final String title;
        private final String headerText;
        private final String contentText;

        public PreloaderMessage(Alert.AlertType messageType, String title, String headerText, String contentText) {
            this.messageType = messageType;
            this.title = title;
            this.headerText = headerText;
            this.contentText = contentText;
        }

        public Alert.AlertType getMessageType() {
            return this.messageType;
        }

        public String getTitle() {
            return this.title;
        }

        public String getHeaderText() {
            return this.headerText;
        }

        public String getContentText() {
            return this.contentText;
        }
    }
}

