/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.smartcardio.CardTerminal;
import lu.nowina.nexu.CardDetector;
import lu.nowina.nexu.api.AppConfig;
import lu.nowina.nexu.api.AuthenticateRequest;
import lu.nowina.nexu.api.AuthenticateResponse;
import lu.nowina.nexu.api.DetectedCard;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.Execution;
import lu.nowina.nexu.api.Feedback;
import lu.nowina.nexu.api.GetCertificateRequest;
import lu.nowina.nexu.api.GetCertificateResponse;
import lu.nowina.nexu.api.GetIdentityInfoRequest;
import lu.nowina.nexu.api.GetIdentityInfoResponse;
import lu.nowina.nexu.api.Match;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.ScAPI;
import lu.nowina.nexu.api.SignatureRequest;
import lu.nowina.nexu.api.SignatureResponse;
import lu.nowina.nexu.api.SystrayMenuItem;
import lu.nowina.nexu.api.TokenId;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.OperationFactory;
import lu.nowina.nexu.api.plugin.HttpPlugin;
import lu.nowina.nexu.cache.FIFOCache;
import lu.nowina.nexu.flow.Flow;
import lu.nowina.nexu.flow.FlowRegistry;
import lu.nowina.nexu.flow.operation.CoreOperationStatus;
import lu.nowina.nexu.generic.ConnectionInfo;
import lu.nowina.nexu.generic.GenericCardAdapter;
import lu.nowina.nexu.generic.SCDatabase;
import lu.nowina.nexu.generic.SCInfo;
import lu.nowina.nexu.view.core.UIDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAPI
implements NexuAPI {
    public static final ThreadGroup EXECUTOR_THREAD_GROUP = new ThreadGroup("ExecutorThreadGroup");
    private Logger logger = LoggerFactory.getLogger(InternalAPI.class.getName());
    private CardDetector detector;
    private List<ProductAdapter> adapters = new ArrayList<ProductAdapter>();
    private Map<TokenId, SignatureTokenConnection> connections;
    private Map<String, HttpPlugin> httpPlugins = new HashMap<String, HttpPlugin>();
    private UIDisplay display;
    private SCDatabase myDatabase;
    private FlowRegistry flowRegistry;
    private OperationFactory operationFactory;
    private AppConfig appConfig;
    private ExecutorService executor;
    private Future<?> currentTask;

    public InternalAPI(UIDisplay display, SCDatabase myDatabase, CardDetector detector, FlowRegistry flowRegistry, OperationFactory operationFactory, AppConfig appConfig) {
        this.display = display;
        this.myDatabase = myDatabase;
        this.detector = detector;
        this.flowRegistry = flowRegistry;
        this.operationFactory = operationFactory;
        this.appConfig = appConfig;
        this.connections = new FIFOCache<TokenId, SignatureTokenConnection>(this.appConfig.getConnectionsCacheMaxSize());
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(EXECUTOR_THREAD_GROUP, r);
                t.setDaemon(true);
                return t;
            }
        });
        this.currentTask = null;
    }

    @Override
    public List<DetectedCard> detectCards() {
        return this.detector.detectCard();
    }

    @Override
    public CardTerminal getCardTerminal(DetectedCard card) {
        return this.detector.getCardTerminal(card);
    }

    @Override
    public List<Match> matchingProductAdapters(Product p) {
        if (p == null) {
            this.logger.warn("Product argument should not be null");
            return Collections.emptyList();
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        for (ProductAdapter adapter : this.adapters) {
            if (!adapter.accept(p)) continue;
            this.logger.info("Product is instance of " + adapter.getClass().getSimpleName());
            matches.add(new Match(adapter, p));
        }
        if (matches.isEmpty() && p instanceof DetectedCard) {
            DetectedCard d = (DetectedCard)p;
            SCInfo info = null;
            if (info == null && this.myDatabase != null) {
                info = this.myDatabase.getInfo(d.getAtr());
                if (info == null) {
                    this.logger.warn("Card " + d.getAtr() + " is not in the personal database");
                } else {
                    matches.add(new Match(new GenericCardAdapter(info), d));
                }
            }
        }
        return matches;
    }

    @Override
    public void registerProductAdapter(ProductAdapter adapter) {
        this.adapters.add(adapter);
    }

    @Override
    public EnvironmentInfo getEnvironmentInfo() {
        EnvironmentInfo info = EnvironmentInfo.buildFromSystemProperties(System.getProperties());
        return info;
    }

    @Override
    public TokenId registerTokenConnection(SignatureTokenConnection connection) {
        TokenId id = new TokenId();
        this.connections.put(id, connection);
        return id;
    }

    @Override
    public SignatureTokenConnection getTokenConnection(TokenId tokenId) {
        return this.connections.get(tokenId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <I, O> Execution<O> executeRequest(Flow<I, O> flow, I request) {
        Execution<Object> resp = null;
        try {
            Object task;
            if (!EXECUTOR_THREAD_GROUP.equals(Thread.currentThread().getThreadGroup())) {
                InternalAPI internalAPI = this;
                synchronized (internalAPI) {
                    if (this.currentTask != null && !this.currentTask.isDone()) {
                        this.currentTask.cancel(true);
                    }
                    this.currentTask = task = this.executor.submit(() -> flow.execute(this, request));
                }
                resp = (Execution)task.get();
            } else {
                resp = flow.execute(this, request);
            }
            if (resp == null) {
                resp = new Execution(CoreOperationStatus.NO_RESPONSE);
            }
            task = resp;
            return task;
        }
        catch (Exception e) {
            resp = new Execution(BasicOperationStatus.EXCEPTION);
            this.logger.error("Cannot execute request", e);
            Feedback feedback = new Feedback(e);
            resp.setFeedback(feedback);
            Execution<Object> execution = resp;
            return execution;
        }
        finally {
            Feedback feedback;
            if (resp.getFeedback() == null) {
                feedback = new Feedback();
                resp.setFeedback(feedback);
            } else {
                feedback = resp.getFeedback();
            }
            feedback.setNexuVersion(this.getAppConfig().getApplicationVersion());
            feedback.setInfo(this.getEnvironmentInfo());
        }
    }

    @Override
    public Execution<GetCertificateResponse> getCertificate(GetCertificateRequest request) {
        Flow flow = this.flowRegistry.getFlow("certificate", this.display, this);
        flow.setOperationFactory(this.operationFactory);
        return this.executeRequest(flow, request);
    }

    @Override
    public Execution<SignatureResponse> sign(SignatureRequest request) {
        Flow flow = this.flowRegistry.getFlow("signature", this.display, this);
        flow.setOperationFactory(this.operationFactory);
        return this.executeRequest(flow, request);
    }

    @Override
    public Execution<GetIdentityInfoResponse> getIdentityInfo(GetIdentityInfoRequest request) {
        Flow flow = this.flowRegistry.getFlow("getIdentityInfo", this.display, this);
        flow.setOperationFactory(this.operationFactory);
        return this.executeRequest(flow, request);
    }

    @Override
    public Execution<AuthenticateResponse> authenticate(AuthenticateRequest request) {
        Flow flow = this.flowRegistry.getFlow("authenticate", this.display, this);
        flow.setOperationFactory(this.operationFactory);
        return this.executeRequest(flow, request);
    }

    @Override
    public HttpPlugin getHttpPlugin(String context) {
        return this.httpPlugins.get(context);
    }

    public void registerHttpContext(String context, HttpPlugin plugin) {
        this.httpPlugins.put(context, plugin);
    }

    public void store(String detectedAtr, ScAPI selectedApi, String apiParam) {
        if (this.myDatabase != null) {
            EnvironmentInfo env = this.getEnvironmentInfo();
            ConnectionInfo cInfo = new ConnectionInfo();
            cInfo.setSelectedApi(selectedApi);
            cInfo.setEnv(env);
            cInfo.setApiParam(apiParam);
            this.myDatabase.add(detectedAtr, cInfo);
        }
    }

    @Override
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @Override
    public List<SystrayMenuItem> getExtensionSystrayMenuItems() {
        ArrayList<SystrayMenuItem> result = new ArrayList<SystrayMenuItem>();
        for (ProductAdapter adapter : this.adapters) {
            SystrayMenuItem menuItem = adapter.getExtensionSystrayMenuItem();
            if (menuItem == null) continue;
            result.add(menuItem);
        }
        return result;
    }

    @Override
    public List<Product> detectProducts() {
        ArrayList<Product> result = new ArrayList<Product>();
        for (ProductAdapter adapter : this.adapters) {
            result.addAll(adapter.detectProducts());
        }
        return result;
    }

    @Override
    public String getLabel(Product p) {
        List<Match> matches = this.matchingProductAdapters(p);
        if (matches.isEmpty()) {
            return p.getLabel();
        }
        ProductAdapter adapter = matches.iterator().next().getAdapter();
        if (adapter.supportMessageDisplayCallback(p)) {
            return adapter.getLabel(this, p, this.display.getPasswordInputCallback(), this.display.getMessageDisplayCallback());
        }
        return adapter.getLabel(this, p, this.display.getPasswordInputCallback());
    }
}

