/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import at.gv.egiz.smcc.util.LinuxLibraryFinder;
import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import lu.nowina.nexu.api.DetectedCard;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardDetector {
    private static final List<String> RESET_CONTEXT_ERRORS = Arrays.asList("SCARD_E_SERVICE_STOPPED", "WINDOWS_ERROR_INVALID_HANDLE", "SCARD_E_INVALID_HANDLE", "SCARD_E_NO_SERVICE");
    private static final Logger logger = LoggerFactory.getLogger(CardDetector.class.getSimpleName());
    private CardTerminals cardTerminals;
    private final WinscardLibrary lib;
    private static final String WINDOWS_PATH = "WinSCard.dll";
    private static final String MAC_PATH = "/System/Library/Frameworks/PCSC.framework/PCSC";
    private static final String PCSC_PATH = "libpcsclite.so.1";

    public CardDetector(EnvironmentInfo info) {
        if (info.getOs() == OS.LINUX) {
            logger.info("The OS is Linux, we check for Library");
            try {
                File libFile = LinuxLibraryFinder.getLibraryPath("pcsclite", "1");
                if (libFile != null) {
                    logger.info("Library installed is at " + libFile.getAbsolutePath());
                    System.setProperty("sun.security.smartcardio.library", libFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.error("Error while loading library for Linux", e);
            }
        }
        this.cardTerminals = null;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (CardDetector.this.cardTerminals != null) {
                    try {
                        CardDetector.this.closeCardTerminals();
                    }
                    catch (Exception e) {
                        logger.warn("Exception when closing cardTerminals", e);
                    }
                }
            }
        });
        String libraryName = Platform.isWindows() ? WINDOWS_PATH : (Platform.isMac() ? MAC_PATH : PCSC_PATH);
        this.lib = (WinscardLibrary)Native.loadLibrary(libraryName, WinscardLibrary.class);
    }

    private List<CardTerminal> getCardTerminals() {
        boolean cardTerminalsCreated;
        if (this.cardTerminals == null) {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            this.cardTerminals = terminalFactory.terminals();
            cardTerminalsCreated = true;
        } else {
            cardTerminalsCreated = false;
        }
        try {
            return this.cardTerminals.list();
        }
        catch (CardException e) {
            Throwable cause = e.getCause();
            if (cause != null && RESET_CONTEXT_ERRORS.contains(cause.getMessage()) && !cardTerminalsCreated) {
                logger.debug("Error class: " + cause.getClass().getName() + ". Message: " + cause.getMessage() + ". Re-establish a new connection.");
                try {
                    this.closeCardTerminals();
                }
                catch (Exception e1) {
                    logger.warn("Exception when closing cardTerminals", e1);
                }
                try {
                    this.establishNewContext();
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
                this.cardTerminals = null;
                return this.getCardTerminals();
            }
            if (cause != null && "SCARD_E_NO_READERS_AVAILABLE".equals(cause.getMessage())) {
                return Collections.emptyList();
            }
            throw new RuntimeException(e);
        }
    }

    public List<DetectedCard> detectCard() {
        ArrayList<DetectedCard> listCardDetect = new ArrayList<DetectedCard>();
        int terminalIndex = 0;
        for (CardTerminal cardTerminal : this.getCardTerminals()) {
            try {
                DetectedCard cardDetection = new DetectedCard();
                Card card = cardTerminal.connect("*");
                ATR atr = card.getATR();
                cardDetection.setAtr(DetectedCard.atrToString(atr.getBytes()));
                cardDetection.setTerminalIndex(terminalIndex);
                cardDetection.setTerminalLabel(cardTerminal.getName());
                listCardDetect.add(cardDetection);
                logger.info(MessageFormat.format("Found card in terminal {0} with ATR {1}.", terminalIndex, cardDetection.getAtr()));
            }
            catch (CardException e) {
                logger.warn(MessageFormat.format("No card present in terminal {0}, or not readable.", Integer.toString(terminalIndex)));
            }
            ++terminalIndex;
        }
        return listCardDetect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardTerminal getCardTerminal(DetectedCard detectedCard) {
        for (CardTerminal cardTerminal : this.getCardTerminals()) {
            Card card = null;
            try {
                card = cardTerminal.connect("*");
                byte[] atr = card.getATR().getBytes();
                if (detectedCard.getTerminalLabel() != null && !cardTerminal.getName().equals(detectedCard.getTerminalLabel()) || !DetectedCard.atrToString(atr).equals(detectedCard.getAtr())) continue;
                CardTerminal cardTerminal2 = cardTerminal;
                return cardTerminal2;
            }
            catch (CardException e) {
                logger.debug("CardException on connect", e);
            }
            finally {
                try {
                    if (card == null) continue;
                    card.disconnect(false);
                }
                catch (CardException e) {
                    logger.warn("CardException on disconnect.", e);
                }
            }
        }
        throw new IllegalArgumentException("Cannot find CardTerminal with label " + detectedCard.getTerminalLabel() + " and ATR " + detectedCard.getAtr());
    }

    private void closeCardTerminals() throws Exception {
        Class<?> pcscTerminalsClass = Class.forName("sun.security.smartcardio.PCSCTerminals");
        Field contextIdField = pcscTerminalsClass.getDeclaredField("contextId");
        contextIdField.setAccessible(true);
        long contextId = contextIdField.getLong(null);
        if (contextId != 0L) {
            Dword result = this.lib.SCardReleaseContext(new SCardContext(contextId));
            if (result.longValue() != 0L) {
                logger.warn("Error when releasing context: " + result.longValue());
            } else {
                logger.debug("Context was released successfully.");
            }
            contextIdField.setLong(null, 0L);
            Field terminalsField = pcscTerminalsClass.getDeclaredField("terminals");
            terminalsField.setAccessible(true);
            Map terminals = (Map)terminalsField.get(null);
            terminals.clear();
        }
    }

    private void establishNewContext() throws Exception {
        Class<?> pcscTerminalsClass = Class.forName("sun.security.smartcardio.PCSCTerminals");
        Method initContextMethod = pcscTerminalsClass.getDeclaredMethod("initContext", new Class[0]);
        initContextMethod.setAccessible(true);
        initContextMethod.invoke(null, new Object[0]);
    }

    public static class SCardContext
    extends Handle {
        private static final long serialVersionUID = 1L;

        public SCardContext() {
            this(0L);
        }

        public SCardContext(long value) {
            super(value);
        }
    }

    public static class Handle
    extends IntegerType {
        private static final long serialVersionUID = 1L;
        public static final int SIZE = Platform.isWindows() ? Pointer.SIZE : Dword.SIZE;

        public Handle(long value) {
            super(SIZE, value);
        }

        @Override
        public String toString() {
            return String.format("%s{%x}", this.getClass().getSimpleName(), this.longValue());
        }
    }

    public static class Dword
    extends IntegerType {
        public static final int SIZE = Platform.isWindows() || Platform.isMac() ? 4 : NativeLong.SIZE;
        private static final long serialVersionUID = 1L;

        public Dword() {
            this(0L);
        }

        public Dword(long value) {
            super(SIZE, value);
        }

        @Override
        public String toString() {
            return Long.toString(this.longValue());
        }
    }

    private static interface WinscardLibrary
    extends Library {
        public Dword SCardReleaseContext(SCardContext var1);
    }
}

