/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.x509;

import iaik.me.asn1.ASN1;
import iaik.me.asn1.Name;
import iaik.me.security.BigInteger;
import iaik.me.security.CryptoException;
import iaik.me.security.PublicKey;
import iaik.me.security.Signature;
import iaik.me.utils.CryptoUtils;
import iaik.me.utils.Util;
import iaik.me.x509.X509Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class X509Certificate {
    private byte[] f;
    private String e;
    private int c;
    private int b;
    private byte[] n;
    private Vector m;
    private Date j;
    private Date i;
    private int l = -1;
    private Name k;
    private Name d;
    private PublicKey h;
    private String o;
    private BigInteger g;
    private int a;
    private static int p;
    private static final Vector q;

    public void verify(PublicKey publicKey) throws CryptoException {
        Signature signature = Signature.getInstance(this.e);
        signature.initVerify(publicKey);
        signature.update(this.n, this.b, this.c);
        if (!signature.verify(this.f)) {
            throw new CryptoException("Signature verification error");
        }
    }

    public void verify() throws CryptoException {
        this.verify(this.h);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a);
        stringBuffer.append("\r\n");
        stringBuffer.append("Serial number: " + this.g);
        stringBuffer.append("\r\n");
        stringBuffer.append("Signature algorithm: " + ASN1.getName(this.o));
        stringBuffer.append("\r\n");
        stringBuffer.append("Subject: " + this.d);
        stringBuffer.append("\r\n");
        stringBuffer.append("Issuer: " + this.k);
        stringBuffer.append("\r\n");
        stringBuffer.append("Valid from: " + this.i.getTime());
        stringBuffer.append("\r\n");
        stringBuffer.append("Valid until: " + this.j.getTime());
        stringBuffer.append("\r\n");
        stringBuffer.append(this.h);
        stringBuffer.append("\r\n");
        Enumeration enumeration = this.extensions();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    private void a(ASN1 aSN1) throws IOException {
        this.m = new Vector();
        Vector vector = aSN1.gvVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ASN1 aSN12 = (ASN1)enumeration.nextElement();
            this.m.addElement(new X509Extension(aSN12));
        }
    }

    private boolean a() {
        if (p < 0) {
            p = Util.loadClass("iaik.me.x509.X509Extension") != null ? 1 : 0;
        }
        return p > 0;
    }

    public int hashCode() {
        if (this.l == -1) {
            this.l = Util.hashCode(this.getEncoded());
        }
        return this.l;
    }

    public int getVersion() {
        return this.a;
    }

    public Name getSubjectDN() {
        return this.d;
    }

    public String getSigAlgOID() {
        return this.o;
    }

    public BigInteger getSerialNumber() {
        return this.g;
    }

    public PublicKey getPublicKey() {
        return this.h;
    }

    public Date getNotBefore() {
        return this.i;
    }

    public Date getNotAfter() {
        return this.j;
    }

    public Name getIssuerDN() {
        return this.k;
    }

    public X509Extension getExtension(String string) {
        Enumeration enumeration = this.extensions();
        while (enumeration.hasMoreElements()) {
            X509Extension x509Extension = (X509Extension)enumeration.nextElement();
            if (!x509Extension.getObjectID().equals(string)) continue;
            return x509Extension;
        }
        return null;
    }

    public byte[] getEncoded() {
        return this.n;
    }

    public Enumeration extensions() {
        if (this.m == null) {
            return q.elements();
        }
        return this.m.elements();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)object;
        return CryptoUtils.equalsBlock(this.getEncoded(), x509Certificate.getEncoded());
    }

    private void a(InputStream inputStream) throws IOException {
        Object object;
        int n;
        ASN1 aSN1 = new ASN1(inputStream, 3, false);
        if (aSN1.getType() != 16) {
            throw new IOException("Not a X.509 certificate, does not start with a sequence!");
        }
        ASN1 aSN12 = aSN1.getElementAt(0);
        this.a = aSN12.getElementAt(n = 0).getType() == Integer.MIN_VALUE ? aSN12.getElementAt(n++).gvASN1().gvInt() + 1 : 1;
        this.g = aSN12.getElementAt(n++).gvBigInteger();
        this.o = aSN12.getElementAt(n++).gvAlgorithm();
        this.k = new Name(aSN12.getElementAt(n++));
        ASN1 aSN13 = aSN12.getElementAt(n++);
        this.i = aSN13.getElementAt(0).gvDate();
        this.j = aSN13.getElementAt(1).gvDate();
        this.d = new Name(aSN12.getElementAt(n++));
        ASN1 aSN14 = aSN12.getElementAt(n++);
        this.h = new PublicKey(aSN14);
        int n2 = aSN12.gvVector().size();
        if (this.a()) {
            while (n < n2) {
                if (((ASN1)(object = aSN12.getElementAt(n++))).getType() != -2147483645) continue;
                ASN1 aSN15 = ((ASN1)object).gvASN1();
                this.a(aSN15);
            }
        }
        this.e = aSN1.getElementAt(1).gvAlgorithm();
        this.f = aSN1.getElementAt(2).gvByteArray();
        this.n = aSN1.getEncoded();
        object = aSN12.getEncoded();
        this.b = 1;
        this.c = ((Object)object).length;
        do {
            ++this.b;
        } while (!CryptoUtils.equalsBlock(this.n, this.b, (byte[])object, 0, this.c));
        this.d.clearASN1();
        this.k.clearASN1();
    }

    public void checkValidity(Date date) throws CryptoException {
        if (date == null) {
            date = new Date();
        }
        if (X509Certificate.b(date, this.i) || X509Certificate.a(date, this.j)) {
            throw new CryptoException("Certificate not valid");
        }
    }

    public void checkValidity() throws CryptoException {
        this.checkValidity(null);
    }

    private static boolean b(Date date, Date date2) {
        long l;
        long l2 = date.getTime();
        return l2 < (l = date2.getTime());
    }

    public static X509Certificate[] arrangeCertificateChain(PublicKey publicKey, X509Certificate[] x509CertificateArray) throws CryptoException {
        Vector<X509Certificate> vector = new Vector<X509Certificate>(x509CertificateArray.length);
        int n = 0;
        while (n < x509CertificateArray.length) {
            if (x509CertificateArray[n] != null) {
                vector.addElement(x509CertificateArray[n]);
            }
            ++n;
        }
        return X509Certificate.arrangeCertificateChain(publicKey, vector);
    }

    public static X509Certificate[] arrangeCertificateChain(PublicKey publicKey, Vector vector) throws CryptoException {
        boolean bl;
        Object object;
        Vector<X509Certificate> vector2 = new Vector<X509Certificate>();
        Object object2 = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            object = (X509Certificate)vector.elementAt(n2);
            if (object != null && ((X509Certificate)object).getPublicKey().equals(publicKey)) {
                vector.setElementAt(null, n2);
                object2 = object;
                break;
            }
            ++n2;
        }
        if (object2 == null) {
            throw new CryptoException("User certificate not found");
        }
        vector2.addElement((X509Certificate)object2);
        object = ((X509Certificate)object2).getIssuerDN();
        block1: do {
            bl = false;
            int n3 = 0;
            while (n3 < n) {
                X509Certificate x509Certificate = (X509Certificate)vector.elementAt(n3);
                if (x509Certificate != null && x509Certificate.getSubjectDN().equals(object)) {
                    bl = true;
                    vector2.addElement(x509Certificate);
                    vector.setElementAt(null, n3);
                    Name name = x509Certificate.getIssuerDN();
                    if (((Name)object).equals(name)) {
                        bl = false;
                        continue block1;
                    }
                    object = name;
                }
                ++n3;
            }
        } while (bl);
        Object[] objectArray = new X509Certificate[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    private static boolean a(Date date, Date date2) {
        long l;
        long l2 = date.getTime();
        return l2 > (l = date2.getTime());
    }

    public X509Certificate(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public X509Certificate(InputStream inputStream) throws IOException {
        this.a(inputStream);
    }

    static {
        q = new Vector(1);
        p = -1;
    }
}

