/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security.rsa;

import iaik.me.asn1.ASN1;
import iaik.me.security.BigInteger;
import iaik.me.security.Cipher;
import iaik.me.security.CryptoBag;
import iaik.me.security.CryptoException;
import iaik.me.security.MessageDigest;
import iaik.me.security.SecureRandom;
import iaik.me.security.rsa.OAEPParams;
import iaik.me.utils.CryptoUtils;
import iaik.me.utils.SysUtil;
import iaik.me.utils.Util;
import java.util.Random;

public class RSA
extends Cipher {
    private OAEPParams k;
    private int b = 2;
    private SecureRandom a;
    private int d;
    private CryptoBag c;
    private static final int l = 3;
    private static final int e = 2;
    private static final int f = 1;
    private static final String j = "OAEP";
    private static final String g = "PKCS1Padding";
    private static final String h = "NoPadding";
    private static final int[] i = new int[]{64, 128, 512, 8};

    public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        throw new CryptoException("Method not supported!");
    }

    private byte[] a(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)(n & 0xFF);
        return byArray;
    }

    protected String setPadding(String string) throws CryptoException {
        if (string == null) {
            string = g;
        }
        if (string.equals(g)) {
            this.b = 2;
        } else if (string.equals(j)) {
            this.b = 3;
        } else if (string.equals(h)) {
            this.b = 1;
        } else {
            throw new CryptoException("Unsupported padding: " + string);
        }
        return string;
    }

    protected String setMode(String string) throws CryptoException {
        if (string == null) {
            string = "ECB";
        }
        if (!string.equals("ECB")) {
            throw new CryptoException("Mode must be ECB!");
        }
        return string;
    }

    private byte[] c(byte[] byArray) {
        int n;
        BigInteger bigInteger = new BigInteger(1, byArray);
        byte[] byArray2 = this.a(bigInteger).toByteArray(false);
        if (byArray2.length < (n = this.b()) && this.b != 3) {
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, n - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    private byte[] b(byte[] byArray) throws CryptoException {
        int n;
        int n2;
        int n3 = byArray.length;
        int n4 = 0;
        int n5 = this.b();
        int n6 = n5 - 3 - n3;
        if (n6 < 8) {
            throw new CryptoException("PKCS#1 requires data at least 11 bytes shorter than the modulus!");
        }
        int n7 = this.d;
        byte[] byArray2 = new byte[n5];
        byArray2[n4++] = 0;
        byArray2[n4++] = (byte)n7;
        if (n7 == 2) {
            if (this.a == null) {
                this.a = SecureRandom.getDefault();
            }
            n2 = 0;
            while (n2 < n6) {
                while ((n = this.a.nextInt() & 0xFF) == 0) {
                }
                byArray2[n4++] = (byte)n;
                ++n2;
            }
        } else {
            n2 = 255;
            n = 0;
            while (n < n6) {
                byArray2[n4++] = (byte)n2;
                ++n;
            }
        }
        byArray2[n4++] = 0;
        System.arraycopy(byArray, 0, byArray2, n4, n3);
        byte[] byArray3 = this.c(byArray2);
        if (byArray3.length < n5) {
            byte[] byArray4 = new byte[n5];
            System.arraycopy(byArray3, 0, byArray4, n5 - byArray3.length, byArray3.length);
            return byArray4;
        }
        return byArray3;
    }

    private byte[] a(byte[] byArray) throws CryptoException {
        int n;
        int n2 = this.b();
        if (byArray.length != n2) {
            throw new CryptoException("Invalid PKCS#1 padding: length of encrypted message does not match modulus length!");
        }
        byte[] byArray2 = this.c(byArray);
        int n3 = byArray2.length;
        if (byArray2[0] != 0) {
            throw new CryptoException("Invalid PKCS#1 padding: no leading zero!");
        }
        int n4 = 1;
        byte by = byArray2[n4];
        if (this.d != by) {
            throw new CryptoException("PKCS#1 padding type does not match specified type!");
        }
        while ((n = byArray2[++n4] & 0xFF) != 0) {
            if (n4 >= n3) {
                throw new CryptoException("Encryption block has wrong format!");
            }
            if (by != 1 || n == 255) continue;
            throw new CryptoException("Invalid block type 1 padding byte " + n + "!");
        }
        if (n4 - 1 < 8) {
            throw new CryptoException("Padding string must be at least 8 octets long!");
        }
        byte[] byArray3 = new byte[n3 - n4 - 1];
        System.arraycopy(byArray2, n4 + 1, byArray3, 0, n3 - n4 - 1);
        return byArray3;
    }

    private byte[] b(byte[] byArray, byte[] byArray2, String string) throws CryptoException {
        int n = this.b() - 1;
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        int n2 = messageDigest.getDigestLength();
        if (byArray2 != null && byArray2.length > n - byArray.length) {
            throw new CryptoException("Bad parameter length!" + byArray2.length);
        }
        if (byArray.length > n - 2 * n2 - 2) {
            throw new CryptoException("Message too long!" + byArray.length);
        }
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = null;
        byArray4 = byArray2 != null ? messageDigest.digest(byArray2) : messageDigest.digest();
        int n3 = n - byArray.length - 2 * n2;
        if (n3 < 0) {
            throw new CryptoException("Bad padding string length!" + n3);
        }
        byte[] byArray5 = new byte[n2];
        Random random = new Random();
        SysUtil.nextBytes(random, byArray5);
        System.arraycopy(byArray5, 0, byArray3, 0, byArray5.length);
        System.arraycopy(byArray4, 0, byArray3, byArray5.length, byArray4.length);
        CryptoUtils.zeroBlock(byArray3, byArray5.length + byArray4.length, n3 - 1);
        byArray3[byArray5.length + byArray4.length + n3 - 1] = 1;
        System.arraycopy(byArray, 0, byArray3, byArray5.length + byArray4.length + n3, byArray.length);
        this.a(byArray3, n2, n - n2, byArray3, 0, n2, messageDigest);
        this.a(byArray3, 0, byArray5.length, byArray3, byArray5.length, n - byArray5.length, messageDigest);
        messageDigest = null;
        byArray5 = null;
        return this.c(byArray3);
    }

    private byte[] a(byte[] byArray, byte[] byArray2, String string) throws CryptoException {
        byte[] byArray3 = this.c(byArray);
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        int n = messageDigest.getDigestLength();
        int n2 = this.b() - 1;
        System.out.println(Util.toString(byArray3));
        this.a(byArray3, 1, n + 1, byArray3, n + 1, n2 - n, messageDigest);
        this.a(byArray3, n + 1, n2 - n + 1, byArray3, 1, n, messageDigest);
        int n3 = 2 * n;
        try {
            while (byArray3[n3] == 0) {
                ++n3;
            }
            if (byArray3[n3++] != 1) {
                throw new CryptoException("Padding string not terminated with 0x01!");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CryptoException("Bad padding string!");
        }
        int n4 = n2 - n3;
        byte[] byArray4 = null;
        byArray4 = byArray2 == null ? messageDigest.digest() : messageDigest.digest(byArray2);
        if (!CryptoUtils.equalsBlock(byArray4, 0, byArray3, n, n)) {
            throw new CryptoException("Parameter hashes do not match!");
        }
        byArray = new byte[n4];
        CryptoUtils.copyBlock(byArray3, n3, byArray, 0, n4);
        byArray3 = null;
        messageDigest = null;
        return byArray;
    }

    private void a(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageDigest messageDigest) {
        byte[] byArray3;
        byte[] byArray4 = new byte[4];
        int n5 = 0;
        int n6 = n + n2;
        while (n < n6) {
            messageDigest.reset();
            this.a(n5++, byArray4);
            messageDigest.update(byArray2, n3, n4);
            byArray3 = messageDigest.digest(byArray4);
            int n7 = 0;
            while (n7 < byArray3.length && n < byArray.length) {
                int n8 = n++;
                int n9 = n7;
                n7 = (short)(n9 + 1);
                byArray[n8] = (byte)(byArray[n8] ^ byArray3[n9]);
            }
        }
        byArray3 = null;
        byArray4 = null;
    }

    public void init(int n, CryptoBag cryptoBag, Object object, SecureRandom secureRandom) throws CryptoException {
        this.mode = n;
        this.a = secureRandom;
        int n2 = cryptoBag.getType();
        if (n2 == 3 || n2 == 12) {
            this.d = n == 1 ? 2 : 1;
        } else if (n2 == 4 || n2 == 13) {
            this.d = n == 1 ? 1 : 2;
        } else {
            throw new CryptoException("Key must be an RSA key!");
        }
        this.c = cryptoBag;
        if (this.b == 2) {
            if (this.b() < 41) {
                throw new CryptoException("PKCS#1 requires a modulus of at least 328 bits!");
            }
        } else if (this.b == 3) {
            if (object == null) {
                object = n2 == 3 || n2 == 4 ? new OAEPParams() : cryptoBag.getOAEP(23);
            }
            this.k = (OAEPParams)object;
        }
    }

    private int b() {
        BigInteger bigInteger = this.c.getBigInteger(2);
        return (bigInteger.bitLength() + 7) / 8;
    }

    public int[] getKeyLength() {
        return i;
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        throw new CryptoException("Method not supported!");
    }

    public byte[] doFinal(byte[] byArray) throws CryptoException {
        byte[] byArray2 = null;
        if (this.b == 1) {
            byArray2 = this.c(byArray);
        } else if (this.b == 2) {
            byArray2 = this.mode == 1 ? this.b(byArray) : this.a(byArray);
        } else {
            String string = null;
            string = ASN1.getName(this.k.gethHashAlgorithm());
            byArray2 = this.mode == 1 ? this.b(byArray, this.k.getPSourceParams(), string) : this.a(byArray, this.k.getPSourceParams(), string);
        }
        return byArray2;
    }

    private BigInteger a(BigInteger bigInteger) {
        BigInteger bigInteger2;
        int n = this.c.getType();
        if (n == 3 || n == 12) {
            BigInteger bigInteger3 = this.c.getBigInteger(3);
            BigInteger bigInteger4 = this.c.getBigInteger(2);
            return bigInteger.modPow(bigInteger3, bigInteger4);
        }
        BigInteger bigInteger5 = this.c.getBigInteger(5);
        BigInteger bigInteger6 = this.c.getBigInteger(6);
        BigInteger bigInteger7 = this.c.getBigInteger(7);
        BigInteger bigInteger8 = this.c.getBigInteger(8);
        BigInteger bigInteger9 = this.c.getBigInteger(9);
        BigInteger bigInteger10 = bigInteger.mod(bigInteger5).modPow(bigInteger7, bigInteger5);
        BigInteger bigInteger11 = bigInteger10.compareTo(bigInteger2 = bigInteger.mod(bigInteger6).modPow(bigInteger8, bigInteger6)) < 0 ? bigInteger10.add(bigInteger5).subtract(bigInteger2) : bigInteger10.subtract(bigInteger2);
        BigInteger bigInteger12 = bigInteger11.multiply(bigInteger9).mod(bigInteger5).multiply(bigInteger6).add(bigInteger2);
        return bigInteger12;
    }

    public RSA() {
        super(0);
    }
}

