/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security.rsa;

import iaik.me.asn1.ASN1;
import iaik.me.security.CryptoException;
import java.io.IOException;
import java.io.InputStream;

public class PssParams {
    private final byte c = (byte)-68;
    private final int d = 20;
    private String a;
    private String b;

    public void setMaskGenFunc(String string) {
        this.b = string;
    }

    public void setHashFunc(String string) {
        this.b = string;
    }

    public byte getTrailerField() {
        return -68;
    }

    public int getSaltLength() {
        return 20;
    }

    public String getMaskGenFunc() {
        return this.a;
    }

    public String getHashFunc() {
        return this.b;
    }

    public byte[] getEncoded() {
        return this.getASN1().getEncoded();
    }

    public ASN1 getASN1() {
        ASN1 aSN1 = ASN1.makeSequence(4);
        ASN1 aSN12 = null;
        if (this.b != null) {
            aSN12 = new ASN1(Integer.MIN_VALUE, ASN1.getObjectId(this.b));
            aSN1.addElement(aSN12);
        }
        if (this.a != null) {
            aSN12 = new ASN1(Integer.MIN_VALUE, ASN1.getObjectId(this.b));
            aSN1.addElement(aSN12);
        }
        return aSN1;
    }

    public PssParams(InputStream inputStream) throws CryptoException, IOException {
        ASN1 aSN1 = new ASN1(inputStream);
        int n = aSN1.getSize();
        int n2 = 0;
        if (n2 < n) {
            switch (aSN1.getElementAt(n2).getType()) {
                case -2147483648: {
                    this.b = ASN1.getName(aSN1.getElementAt(n2).gvObjectId());
                }
                case -2147483647: {
                    this.a = ASN1.getName(aSN1.getElementAt(n2).gvObjectId());
                }
                case -2147483646: {
                    int n3 = aSN1.getElementAt(n2).gvInt();
                    if (n3 != 20) {
                        throw new CryptoException("Wrong salt length value!" + n3);
                    }
                }
                case -2147483645: {
                    byte by = (byte)aSN1.getElementAt(n2).gvInt();
                    if (by == -68) break;
                    throw new CryptoException("Wrong trailer field!" + by);
                }
            }
            throw new CryptoException("Wrong encoding!" + aSN1);
        }
    }

    public PssParams() {
        this.a = null;
        this.b = null;
    }
}

