/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security.dsa;

import iaik.me.asn1.ASN1;
import iaik.me.security.BigInteger;
import iaik.me.security.CryptoBag;
import iaik.me.security.CryptoException;
import iaik.me.security.MessageDigest;
import iaik.me.security.PrivateKey;
import iaik.me.security.PublicKey;
import iaik.me.security.SecureRandom;
import iaik.me.security.Signature;
import java.io.IOException;
import java.util.Vector;

public class DSASignature
extends Signature {
    private int c;
    private byte[] d;
    private PrivateKey b;
    private PublicKey a;

    public boolean verify(byte[] byArray) throws CryptoException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object;
        if (this.a == null) {
            throw new CryptoException("Not initialized for verify!");
        }
        if (this.md != null) {
            this.d = this.md.digest();
        } else {
            if (this.c != 20) {
                throw new CryptoException("Data must be 20 bytes long for RawDSA");
            }
            this.c = 0;
        }
        try {
            object = new ASN1(byArray);
            bigInteger2 = ((ASN1)object).getElementAt(0).gvBigInteger();
            bigInteger = ((ASN1)object).getElementAt(1).gvBigInteger();
        }
        catch (IOException iOException) {
            throw new CryptoException("DSA signature ASN.1 error: " + iOException.toString());
        }
        object = this.a.getBigInteger(11);
        CryptoBag cryptoBag = this.a.getCryptoBag(12);
        BigInteger bigInteger3 = cryptoBag.getBigInteger(13);
        BigInteger bigInteger4 = cryptoBag.getBigInteger(14);
        BigInteger bigInteger5 = cryptoBag.getBigInteger(15);
        if (bigInteger2.compareTo(bigInteger4) >= 0 || bigInteger.compareTo(bigInteger4) >= 0) {
            return false;
        }
        BigInteger bigInteger6 = bigInteger.modInverse(bigInteger4);
        BigInteger bigInteger7 = new BigInteger(1, this.d);
        BigInteger bigInteger8 = bigInteger7.multiply(bigInteger6).mod(bigInteger4);
        BigInteger bigInteger9 = bigInteger2.multiply(bigInteger6).mod(bigInteger4);
        BigInteger bigInteger10 = bigInteger5.modPow(bigInteger8, bigInteger3).multiply(((BigInteger)object).modPow(bigInteger9, bigInteger3)).mod(bigInteger3).mod(bigInteger4);
        return bigInteger2.equals(bigInteger10);
    }

    public void update(byte[] byArray, int n, int n2) throws CryptoException {
        if (this.md != null) {
            this.md.update(byArray, n, n2);
        } else {
            try {
                int n3 = 0;
                while (n3 < n2) {
                    this.d[this.c++] = byArray[n + n3];
                    ++n3;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new CryptoException("Data must be 20 bytes long for RawDSA");
            }
        }
    }

    public byte[] sign() throws CryptoException {
        if (this.b == null) {
            throw new CryptoException("Not initialized for sign!");
        }
        if (this.md != null) {
            this.d = this.md.digest();
        } else {
            if (this.c != 20) {
                throw new CryptoException("Data must be 20 bytes long for RawDSA");
            }
            this.c = 0;
        }
        BigInteger bigInteger = this.b.getBigInteger(10);
        CryptoBag cryptoBag = this.b.getCryptoBag(12);
        BigInteger bigInteger2 = cryptoBag.getBigInteger(13);
        BigInteger bigInteger3 = cryptoBag.getBigInteger(14);
        BigInteger bigInteger4 = cryptoBag.getBigInteger(15);
        BigInteger bigInteger5 = BigInteger.ONE;
        BigInteger bigInteger6 = new BigInteger(bigInteger3.bitLength() + 8, this.random);
        BigInteger bigInteger7 = bigInteger6.mod(bigInteger3.subtract(bigInteger5)).add(bigInteger5);
        BigInteger bigInteger8 = bigInteger4.modPow(bigInteger7, bigInteger2).mod(bigInteger3);
        BigInteger bigInteger9 = new BigInteger(1, this.d);
        BigInteger bigInteger10 = bigInteger7.modInverse(bigInteger3).multiply(bigInteger9.add(bigInteger.multiply(bigInteger8))).mod(bigInteger3);
        Vector<ASN1> vector = new Vector<ASN1>();
        vector.addElement(new ASN1(2, bigInteger8));
        vector.addElement(new ASN1(2, bigInteger10));
        ASN1 aSN1 = new ASN1(16, vector);
        return aSN1.getEncoded();
    }

    public void initVerify(PublicKey publicKey) throws CryptoException {
        this.b();
        if (publicKey.getType() != 5) {
            throw new CryptoException("Must be DSA key");
        }
        this.a = publicKey;
        this.b = null;
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws CryptoException {
        this.b();
        if (privateKey.getType() != 6) {
            throw new CryptoException("Must be DSA key");
        }
        this.random = secureRandom == null ? SecureRandom.getDefault() : secureRandom;
        this.a = null;
        this.b = privateKey;
    }

    private void b() throws CryptoException {
        if (this.md != null || this.d != null) {
            return;
        }
        if (this.getAlgorithm().equals("RawDSA")) {
            this.d = new byte[20];
            this.c = 0;
        } else {
            this.md = MessageDigest.getInstance("SHA");
        }
    }
}

