/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security.dsa;

import iaik.me.security.BigInteger;
import iaik.me.security.CryptoBag;
import iaik.me.security.CryptoException;
import iaik.me.security.KeyPairGenerator;
import iaik.me.security.PrivateKey;
import iaik.me.security.PublicKey;
import iaik.me.security.SecureRandom;
import iaik.me.utils.Util;
import java.util.Hashtable;

public class DSAKeyPairGenerator
extends KeyPairGenerator {
    private CryptoBag b;
    private SecureRandom a;
    private int d;
    private static Hashtable c;

    public void initialize(int n, Object object, SecureRandom secureRandom, Object object2) throws CryptoException {
        this.initialize(n, object, secureRandom);
    }

    public void initialize(int n, Object object, SecureRandom secureRandom) throws CryptoException {
        if (n < 512) {
            n = 512;
        }
        if (n > 4096) {
            n = 4096;
        }
        this.d = n;
        this.a = secureRandom;
        if (object != null) {
            if (!(object instanceof CryptoBag)) {
                throw new CryptoException("Parameter must be DSA parameters!");
            }
            CryptoBag cryptoBag = (CryptoBag)object;
            if (cryptoBag.getType() != 7) {
                throw new CryptoException("Parameter must be DSA parameters!");
            }
            int n2 = cryptoBag.getBigInteger(13).bitLength();
            c.put(new Integer(n2), cryptoBag);
            if (n != n2) {
                throw new CryptoException("Specified parameters do not match specified key length");
            }
            this.b = cryptoBag;
        }
        if (this.b == null) {
            this.b = (CryptoBag)c.get(new Integer(n));
            if (this.b == null) {
                throw new CryptoException("No DSA parameters of " + n + " bit available");
            }
        }
    }

    public CryptoBag generateKeyPair() {
        BigInteger bigInteger;
        if (this.d == 0) {
            try {
                this.initialize(1024, null, null);
            }
            catch (CryptoException cryptoException) {
                throw new RuntimeException(cryptoException.toString());
            }
        }
        if (this.a == null) {
            this.a = SecureRandom.getDefault();
        }
        BigInteger bigInteger2 = this.b.getBigInteger(13);
        BigInteger bigInteger3 = this.b.getBigInteger(14);
        BigInteger bigInteger4 = this.b.getBigInteger(15);
        do {
            bigInteger = new BigInteger(this.d + 8, this.a);
        } while ((bigInteger = bigInteger.mod(bigInteger3)).signum() == 0);
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger, bigInteger2);
        PublicKey publicKey = PublicKey.makeDSAPublicKey(bigInteger5, this.b);
        PrivateKey privateKey = PrivateKey.makeDSAPrivateKey(bigInteger, this.b);
        CryptoBag cryptoBag = CryptoBag.makeKeyPair(publicKey, privateKey);
        return cryptoBag;
    }

    private static void a(int n, String string, String string2, String string3) {
        BigInteger bigInteger = new BigInteger(Util.decodeByteArray(string));
        BigInteger bigInteger2 = new BigInteger(Util.decodeByteArray(string2));
        BigInteger bigInteger3 = new BigInteger(Util.decodeByteArray(string3));
        CryptoBag cryptoBag = CryptoBag.makeDSAParameters(bigInteger, bigInteger2, bigInteger3);
        c.put(new Integer(n), cryptoBag);
    }

    static {
        String string = "AMFsutNNR17FOWaV1pS8i8R+WY4jtanXxc7ILWW2gn1E6VN4SEcwwL/x9MtW9HxuUQVL6JIA8w1D3E/vliTUZls=";
        String string2 = "ALe4ELWMCTT2QoePNguW18wmtT5N";
        String string3 = "TFPHJr2/u6ZUnX5zGTnGyTqGmifF2xe6PKxYnXs+AD+nNfKQz9B6PvEPNRVfGi73AzWve2pSEaEQNRj7pE6XGA==";
        String string4 = "AOT9vewnOriGLidtX+5nSLI/zHJl/8YAzQHgM2iqtUhyqmyY9NeWu32QzLNqRfVaBbugbd3VPRtBGWDaCW+sB18oM7+PFzvqlspTAmpDsXycAP1Rtp6kBMDWCWuqZUvdKw==";
        String string5 = "AIPclbIFammk44gXcrMEancCGn1p";
        String string6 = "Yvl0Wgb7D6OpTrbm2P1OyBzgSxpm9MLn4PwrdFElKdM4FsKmv5A6F+hAZkLqTPKef9bRLhZzTwZTW/vRphw28Si69HoeYg363PVsduSMR5zCDCv7s2+qjDaDTpbIRCDQ";
        String string7 = "AIJ91JyiBWmE6YNxsTQNXXGDkoWyWsqjgtesOG6UQIQ/CkZ6qHWowco7cLpqlwcS9rGZ7T7sUxPzlApnu9afOHIpYasCPRehMzxSI12ft9EOleOlXvmwT8fJIMVy2nrD1Q8kDbuOVNqeu3AhEcU1guU1hS6fWTl5szJQyIaDlhkX";
        String string8 = "APpQedr6Pzqx6Apt9b0W8iTY+Ncb";
        String string9 = "T731LjME8FHBfKVck4G1wX1MIFB2hTRQz9n8crLhsrFvoBBIuP8X56kK4eAYBT402dVh33FMyNySsVG132ZZcGteV8MZotZYO30y0unh8WY+qqxGDc1OZ3A29/m+Cy4WoF1pXVuBE6kDyzhjVhq9NkpdbBVmF/oQoyCZ4dI0dxM=";
        String string10 = "ANooRHRpxzN9PmlUJphGsWypqm+gtPoGL8F7hTqV1Ku8HuuafHdxPKWu7/ksRykRYEPsuQGLNzNVkGQrYdZzq6i9/pPy8h/rhmRhuQZy4yMvLs3chlVPB8e8poDSenv2eJ6VzyOR/+n9mLCK7klwD4IzLBWFAbAfrwT6gwfIED3ZczIeKW/Ant3o9Ajw9ou2RWxYRCJgI1x7/fDjqvbk/w3y32rtkRzZcDhEB5XWwx38BeVcwPSJs0zVXZOgXjX0+VNSVIhrV15+g7toOndAdBSnUOwN1sp01bHOGyCMSUdSJa2rd9Ri+Fzj4mUloehyf6U/jxKMRFEK3jhJqJG13pE=";
        String string11 = "AKCfbLCNGtGiTWJlXHLuKypjkV1b";
        String string12 = "AIB7+MXkOUojD2UcxR7RKjqzsIE8J1yIY8IRTQV/M1pGb0O5uf0CfAYMS86MHaf5+pctseCzbxZOLQCreenkWKVm4bNE3+AELU3Y64HKRS/Y4NOw9u+BLi4/n6NQsLefG3xqd4vGnCtDW6T1KUVDfdN8/yO6jbD2m1nWQoubOqFsUMb7i1Pftv3XJ6J1pehHHg4rpkqo/r7798u5Kws1q4kQTj0QIWZ1HYD38LEgUBUKY0wfn2Rb5Ahcet8FAp2o32S6qoMizhUSNqYueAtBY0CsIDcOsq0noNPq/6gIRMmLmBGcV1hWYkpuisQbUBYp72rIj58nuhOrURVMeMFzxH4=";
        c = new Hashtable(8);
        DSAKeyPairGenerator.a(512, string, string2, string3);
        DSAKeyPairGenerator.a(768, string4, string5, string6);
        DSAKeyPairGenerator.a(1024, string7, string8, string9);
        DSAKeyPairGenerator.a(2048, string10, string11, string12);
    }
}

