/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security;

import iaik.me.asn1.ASN1;
import iaik.me.security.BigInteger;
import iaik.me.security.CryptoBag;
import iaik.me.security.PublicKey;
import iaik.me.security.rsa.OAEPParams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PrivateKey
extends CryptoBag {
    public static PrivateKey makeRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        PrivateKey privateKey = new PrivateKey(4);
        return PrivateKey.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, privateKey);
    }

    public static PrivateKey makeRSAOAEPPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, OAEPParams oAEPParams) {
        PrivateKey privateKey = new PrivateKey(13);
        privateKey = PrivateKey.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, privateKey);
        privateKey.a(23, oAEPParams);
        return privateKey;
    }

    private static PrivateKey a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, PrivateKey privateKey) {
        privateKey.a(2, bigInteger);
        privateKey.a(3, bigInteger2);
        privateKey.a(4, bigInteger3);
        privateKey.a(5, bigInteger4);
        privateKey.a(6, bigInteger5);
        privateKey.a(7, bigInteger6);
        privateKey.a(8, bigInteger7);
        privateKey.a(9, bigInteger8);
        return privateKey;
    }

    public static PrivateKey makeDSAPrivateKey(BigInteger bigInteger, CryptoBag cryptoBag) {
        if (cryptoBag.getType() != 7) {
            throw new RuntimeException("Parameters must be DSA parameters!");
        }
        PrivateKey privateKey = new PrivateKey(6);
        privateKey.a(10, bigInteger);
        privateKey.a(12, cryptoBag);
        return privateKey;
    }

    public static PrivateKey makeDHPrivateKey(BigInteger bigInteger, CryptoBag cryptoBag) {
        if (cryptoBag.getType() != 10) {
            throw new RuntimeException("Parameters must be DH parameters!");
        }
        PrivateKey privateKey = new PrivateKey(9);
        privateKey.a(16, bigInteger);
        privateKey.a(18, cryptoBag);
        return privateKey;
    }

    public PublicKey getPublicKey() {
        int n = this.getType();
        if (n == 4) {
            BigInteger bigInteger = this.getBigInteger(2);
            BigInteger bigInteger2 = this.getBigInteger(3);
            return PublicKey.makeRSAPublicKey(bigInteger, bigInteger2);
        }
        if (n == 6) {
            BigInteger bigInteger = this.getBigInteger(10);
            CryptoBag cryptoBag = this.getCryptoBag(12);
            BigInteger bigInteger3 = cryptoBag.getBigInteger(15);
            BigInteger bigInteger4 = cryptoBag.getBigInteger(13);
            BigInteger bigInteger5 = bigInteger3.modPow(bigInteger, bigInteger4);
            return PublicKey.makeDSAPublicKey(bigInteger5, cryptoBag);
        }
        if (n == 9) {
            BigInteger bigInteger = this.getBigInteger(16);
            CryptoBag cryptoBag = this.getCryptoBag(18);
            BigInteger bigInteger6 = cryptoBag.getBigInteger(20);
            BigInteger bigInteger7 = cryptoBag.getBigInteger(19);
            BigInteger bigInteger8 = bigInteger6.modPow(bigInteger, bigInteger7);
            return PublicKey.makeDHPublicKey(bigInteger8, cryptoBag);
        }
        BigInteger bigInteger = this.getBigInteger(2);
        BigInteger bigInteger9 = this.getBigInteger(3);
        OAEPParams oAEPParams = this.getOAEP(23);
        return PublicKey.makeRSAOAEPPublicKey(bigInteger, bigInteger9, oAEPParams);
    }

    public ASN1 getASN1() {
        ASN1 aSN1;
        ASN1 aSN12 = ASN1.makeSequence(3);
        aSN12.addElement(new ASN1(2, BigInteger.ZERO));
        int n = this.getType();
        switch (n) {
            case 4: 
            case 13: {
                if (n == 13) {
                    OAEPParams oAEPParams = this.getOAEP(23);
                    aSN12.addElement(ASN1.makeAlgorithmId(ASN1.getObjectId("RSAES-OAEP"), oAEPParams.getASN1()));
                } else {
                    aSN12.addElement(ASN1.makeAlgorithmId(ASN1.getObjectId("RSA"), null));
                }
                aSN1 = ASN1.makeSequence(9);
                aSN1.addElement(new ASN1(2, BigInteger.ZERO));
                aSN1.addElement(new ASN1(2, this.getBigInteger(2)));
                aSN1.addElement(new ASN1(2, this.getBigInteger(3)));
                aSN1.addElement(new ASN1(2, this.getBigInteger(4)));
                aSN1.addElement(new ASN1(2, this.getBigInteger(5)));
                aSN1.addElement(new ASN1(2, this.getBigInteger(6)));
                aSN1.addElement(new ASN1(2, this.getBigInteger(7)));
                aSN1.addElement(new ASN1(2, this.getBigInteger(8)));
                aSN1.addElement(new ASN1(2, this.getBigInteger(9)));
                break;
            }
            case 6: {
                aSN12.addElement(this.getCryptoBag(12).getASN1());
                aSN1 = new ASN1(2, this.getBigInteger(10));
                break;
            }
            case 9: {
                aSN12.addElement(this.getCryptoBag(18).getASN1());
                aSN1 = new ASN1(2, this.getBigInteger(16));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        aSN12.addElement(new ASN1(4, aSN1.getEncoded()));
        return aSN12;
    }

    private void a(ASN1 aSN1, int n) throws IOException {
        if (n != 4 && n != 13) {
            throw new IOException("Invalid type: " + n);
        }
        this.c(n);
        int n2 = 0;
        BigInteger bigInteger = aSN1.getElementAt(n2++).gvBigInteger();
        this.a(2, aSN1.getElementAt(n2++).gvBigInteger());
        this.a(3, aSN1.getElementAt(n2++).gvBigInteger());
        this.a(4, aSN1.getElementAt(n2++).gvBigInteger());
        this.a(5, aSN1.getElementAt(n2++).gvBigInteger());
        this.a(6, aSN1.getElementAt(n2++).gvBigInteger());
        this.a(7, aSN1.getElementAt(n2++).gvBigInteger());
        this.a(8, aSN1.getElementAt(n2++).gvBigInteger());
        this.a(9, aSN1.getElementAt(n2++).gvBigInteger());
    }

    private void a(ASN1 aSN1) throws IOException {
        if (aSN1.getType() != 16) {
            throw new IOException("Not a PrivateKeyInfo!");
        }
        BigInteger bigInteger = aSN1.getElementAt(0).gvBigInteger();
        String string = aSN1.getElementAt(1).gvAlgorithm();
        byte[] byArray = aSN1.getElementAt(2).gvByteArray();
        ASN1 aSN12 = new ASN1(byArray);
        String string2 = ASN1.getName(string);
        if (string2.equals("RSA")) {
            this.a(aSN12, 4);
        } else if (string2.equals("DSA")) {
            this.c(6);
            this.a(10, aSN12.gvBigInteger());
            CryptoBag cryptoBag = new CryptoBag(aSN1.getElementAt(1));
            if (cryptoBag.getType() != 7) {
                throw new IOException("Invalid ASN.1 algorithm parameters, not DSA");
            }
            this.a(12, cryptoBag);
        } else if (string2.equals("DH")) {
            this.c(9);
            this.a(16, aSN12.gvBigInteger());
            CryptoBag cryptoBag = new CryptoBag(aSN1.getElementAt(1));
            if (cryptoBag.getType() != 10) {
                throw new IOException("Invalid ASN.1 algorithm parameters, not DH");
            }
            this.a(18, cryptoBag);
        } else if (string2.equals("RSAES-OAEP")) {
            this.a(aSN12, 13);
            ASN1 aSN13 = aSN1.getElementAt(1).getElementAt(1);
            OAEPParams oAEPParams = aSN13 != null ? new OAEPParams(aSN13) : null;
            this.a(23, oAEPParams);
            this.a(2, aSN12.getElementAt(1).gvBigInteger());
            this.a(3, aSN12.getElementAt(2).gvBigInteger());
        } else {
            throw new IOException("Unknown private key algorithm " + string);
        }
    }

    public PrivateKey(byte[] byArray, int n) throws IOException {
        this(new ByteArrayInputStream(byArray), n);
    }

    public PrivateKey(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public PrivateKey(InputStream inputStream, int n) throws IOException {
        this.a(new ASN1(inputStream), n);
    }

    public PrivateKey(InputStream inputStream) throws IOException {
        this(new ASN1(inputStream));
    }

    public PrivateKey(ASN1 aSN1) throws IOException {
        this.a(aSN1);
    }

    private PrivateKey(int n) {
        super(n);
    }
}

