/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security;

import iaik.me.asn1.ASN1;
import iaik.me.security.BigInteger;
import iaik.me.security.PrivateKey;
import iaik.me.security.PublicKey;
import iaik.me.security.rsa.OAEPParams;
import iaik.me.utils.Util;
import java.io.IOException;

public class CryptoBag {
    private static final Class d;
    private static final Class c;
    protected byte[] NULL_VALUE = new byte[0];
    private Object[] a;
    private int b;
    private static final String[] e;
    private static final int h = -33;
    public static final int V_OAEP_PARAMS = 23;
    public static final int V_KEY_PRIVATE = 22;
    public static final int V_KEY_PUBLIC = 21;
    public static final int V_DH_G = 20;
    public static final int V_DH_P = 19;
    public static final int V_DH_PARAMS = 18;
    public static final int V_DH_Y = 17;
    public static final int V_DH_X = 16;
    public static final int V_DSA_G = 15;
    public static final int V_DSA_Q = 14;
    public static final int V_DSA_P = 13;
    public static final int V_DSA_PARAMS = 12;
    public static final int V_DSA_Y = 11;
    public static final int V_DSA_X = 10;
    public static final int V_RSA_CRT_QINV = 9;
    public static final int V_RSA_CRT_EQ = 8;
    public static final int V_RSA_CRT_EP = 7;
    public static final int V_RSA_CRT_Q = 6;
    public static final int V_RSA_CRT_P = 5;
    public static final int V_RSA_D = 4;
    public static final int V_RSA_E = 3;
    public static final int V_RSA_N = 2;
    public static final int V_IV = 1;
    public static final int V_KEY = 0;
    private static final int g = 13;
    private static final int f = 1;
    public static final int TYPE_RSA_OAEP_PRIVATE = 13;
    public static final int TYPE_RSA_OAEP_PUBLIC = 12;
    public static final int TYPE_KEYPAIR = 11;
    public static final int TYPE_DH_PARAMS = 10;
    public static final int TYPE_DH_PRIVATE = 9;
    public static final int TYPE_DH_PUBLIC = 8;
    public static final int TYPE_DSA_PARAMS = 7;
    public static final int TYPE_DSA_PRIVATE = 6;
    public static final int TYPE_DSA_PUBLIC = 5;
    public static final int TYPE_RSA_PRIVATE = 4;
    public static final int TYPE_RSA_PUBLIC = 3;
    public static final int TYPE_IV = 2;
    public static final int TYPE_SECRET_KEY = 1;

    private String a(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        string = String.valueOf(string) + " ";
        Class<?> clazz = this.getClass();
        if (clazz == c) {
            stringBuffer.append("PublicKey ");
        } else if (clazz == d) {
            stringBuffer.append("PrivateKey ");
        } else {
            stringBuffer.append("CryptoBag ");
        }
        stringBuffer.append("type ");
        stringBuffer.append(this.b);
        stringBuffer.append(", ");
        stringBuffer.append(this.a.length);
        stringBuffer.append(" elements:");
        int n = 0;
        while (n < this.a.length) {
            stringBuffer.append("\r\n");
            Object object = this.a[n];
            if (object instanceof byte[]) {
                stringBuffer.append(string);
                stringBuffer.append(Util.toString((byte[])object));
            } else if (object instanceof CryptoBag) {
                stringBuffer.append(((CryptoBag)object).a(string));
            } else {
                stringBuffer.append(string);
                stringBuffer.append(object.toString());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.a("");
    }

    void c(int n) {
        if (n < 1 || n > 13) {
            throw new RuntimeException("Invalid type " + n);
        }
        this.b = n;
        String string = e[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = (string.charAt(n3) & 0xFFFFFFDF) - 65;
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        this.a = new Object[n2 + 1];
    }

    void a(int n, Object object) {
        if (object == null) {
            throw new NullPointerException("value is null");
        }
        this.a[this.b((int)n)] = object;
    }

    public static CryptoBag makeSecretKey(byte[] byArray) {
        CryptoBag cryptoBag = new CryptoBag(1);
        cryptoBag.a(0, byArray);
        return cryptoBag;
    }

    public static CryptoBag makeKeyPair(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey == null) {
            publicKey = privateKey.getPublicKey();
        }
        CryptoBag cryptoBag = new CryptoBag(11);
        cryptoBag.a(21, publicKey);
        cryptoBag.a(22, privateKey);
        return cryptoBag;
    }

    public static CryptoBag makeIV(byte[] byArray) {
        CryptoBag cryptoBag = new CryptoBag(2);
        cryptoBag.a(1, byArray);
        return cryptoBag;
    }

    public static CryptoBag makeDSAParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        CryptoBag cryptoBag = new CryptoBag(7);
        cryptoBag.a(13, bigInteger);
        cryptoBag.a(14, bigInteger2);
        cryptoBag.a(15, bigInteger3);
        return cryptoBag;
    }

    public static CryptoBag makeDHParameters(BigInteger bigInteger, BigInteger bigInteger2) {
        CryptoBag cryptoBag = new CryptoBag(10);
        cryptoBag.a(19, bigInteger);
        cryptoBag.a(20, bigInteger2);
        return cryptoBag;
    }

    public int hashCode() {
        int n = this.b;
        int n2 = 0;
        while (n2 < this.a.length) {
            n ^= Util.hashCode(this.a[n2]);
            ++n2;
        }
        return n;
    }

    public int getType() {
        return this.b;
    }

    public OAEPParams getOAEP(int n) {
        return (OAEPParams)this.a(n);
    }

    public int getKeyLength() {
        switch (this.b) {
            case 1: {
                return this.getByteArray(0).length << 3;
            }
            case 2: {
                return this.getByteArray(1).length << 3;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: {
                return this.getBigInteger(2).bitLength();
            }
            case 5: 
            case 6: {
                return this.getCryptoBag(12).getKeyLength();
            }
            case 7: {
                return this.getBigInteger(13).bitLength();
            }
            case 8: 
            case 9: {
                return this.getCryptoBag(18).getKeyLength();
            }
            case 10: {
                return this.getBigInteger(19).bitLength();
            }
            case 11: {
                return this.getCryptoBag(21).getKeyLength();
            }
        }
        return 0;
    }

    private int b(int n) {
        String string = e[this.b];
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Invalid parameter " + n + " for type " + this.b);
        }
        int n2 = (string.charAt(n) & 0xFFFFFFDF) - 65;
        if (n2 < 0 || n2 >= this.a.length) {
            throw new IndexOutOfBoundsException("Invalid parameter " + n + " for type " + this.b);
        }
        return n2;
    }

    public byte[] getEncoded() {
        return this.getASN1().getEncoded();
    }

    public CryptoBag getCryptoBag(int n) {
        return (CryptoBag)this.a(n);
    }

    public byte[] getByteArray(int n) {
        return (byte[])this.a(n);
    }

    public BigInteger getBigInteger(int n) {
        return (BigInteger)this.a(n);
    }

    public ASN1 getASN1() {
        ASN1 aSN1;
        switch (this.getType()) {
            case 7: {
                ASN1 aSN12 = ASN1.makeSequence(3);
                aSN12.addElement(new ASN1(2, this.getBigInteger(13)));
                aSN12.addElement(new ASN1(2, this.getBigInteger(14)));
                aSN12.addElement(new ASN1(2, this.getBigInteger(15)));
                aSN1 = ASN1.makeAlgorithmId(ASN1.getObjectId("DSA"), aSN12);
                break;
            }
            case 10: {
                ASN1 aSN13 = ASN1.makeSequence(2);
                aSN13.addElement(new ASN1(2, this.getBigInteger(19)));
                aSN13.addElement(new ASN1(2, this.getBigInteger(20)));
                aSN1 = ASN1.makeAlgorithmId(ASN1.getObjectId("DH"), aSN13);
                break;
            }
            default: {
                throw new RuntimeException("Encoding of type " + this.getType() + " not supported");
            }
        }
        return aSN1;
    }

    private Object a(int n) {
        return this.a[this.b(n)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CryptoBag)) {
            return false;
        }
        CryptoBag cryptoBag = (CryptoBag)object;
        if (this.b != cryptoBag.b) {
            return false;
        }
        int n = 0;
        while (n < this.a.length) {
            if (!Util.equals(this.a[n], cryptoBag.a[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void a(ASN1 aSN1) throws IOException {
        if (aSN1.getType() != 16) {
            throw new IOException("No AlgorithmParameters, not a sequence!");
        }
        String string = aSN1.getElementAt(0).gvString();
        String string2 = ASN1.getName(string);
        if (string2.equals("DSA")) {
            ASN1 aSN12 = aSN1.getElementAt(1);
            BigInteger bigInteger = aSN12.getElementAt(0).gvBigInteger();
            BigInteger bigInteger2 = aSN12.getElementAt(1).gvBigInteger();
            BigInteger bigInteger3 = aSN12.getElementAt(2).gvBigInteger();
            this.c(7);
            this.a(13, bigInteger);
            this.a(14, bigInteger2);
            this.a(15, bigInteger3);
        } else if (string2.equals("DH")) {
            ASN1 aSN13 = aSN1.getElementAt(1);
            BigInteger bigInteger = aSN13.getElementAt(0).gvBigInteger();
            BigInteger bigInteger4 = aSN13.getElementAt(1).gvBigInteger();
            this.c(10);
            this.a(19, bigInteger);
            this.a(20, bigInteger4);
        } else {
            throw new IOException("Unsupported algorithm " + string2);
        }
    }

    public CryptoBag(ASN1 aSN1) throws IOException {
        this();
        this.a(aSN1);
    }

    CryptoBag(int n) {
        this();
        this.c(n);
    }

    CryptoBag() {
    }

    static {
        e = new String[]{"", "A", " a", "  ab", "  abCDEFGH", "           ab", "          A b", "             abc", "                 ab", "                A b", "                   ab", "                     ab", "  ab                   C", "  abCDEFGH             I"};
        c = Util.loadClass("iaik.me.security.PublicKey");
        d = Util.loadClass("iaik.me.security.PrivateKey");
    }
}

