/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security;

import iaik.me.asn1.ASN1;
import iaik.me.security.CryptoBag;
import iaik.me.security.CryptoException;
import iaik.me.security.SecureRandom;
import iaik.me.utils.CryptoUtils;
import iaik.me.utils.SimpleStringTokenizer;
import iaik.me.utils.Util;
import java.util.Hashtable;

public abstract class Cipher {
    private static String b = "iaik.me.security.cipher.";
    private int c;
    private byte[] d;
    private int a;
    protected int chainingMode;
    protected byte[] iv;
    protected int mode;
    private int e;
    private String g;
    private static Hashtable f;
    protected static final int MODE_CBC = 6;
    protected static final int MODE_ECB = 5;
    private static final int j = 5;
    private static final int h = 4;
    private static final int i = 3;
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE = 1;

    protected int updateInternal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws CryptoException {
        int n4;
        block8: {
            block7: {
                n4 = 0;
                if (this.mode == 2 && !bl) {
                    n2 -= this.e;
                }
                if (this.c != 0) {
                    while (n2 > 0 && this.c < this.e) {
                        this.d[this.c++] = byArray[n++];
                        --n2;
                    }
                    if (this.c == this.e) {
                        this.cryptBlock(this.d, 0, byArray2, n3);
                        this.c = 0;
                        n3 += this.e;
                        n4 += this.e;
                    }
                }
                while (n2 >= this.e) {
                    this.cryptBlock(byArray, n, byArray2, n3);
                    n += this.e;
                    n3 += this.e;
                    n4 += this.e;
                    n2 -= this.e;
                }
                if (this.mode != 1) break block7;
                while (n2 > 0) {
                    this.d[this.c++] = byArray[n++];
                    --n2;
                }
                break block8;
            }
            if (bl) break block8;
            int n5 = this.e;
            while (n5 > 0) {
                this.d[this.c++] = byArray[n++];
                --n5;
            }
        }
        return n4;
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        return this.updateInternal(byArray, n, n2, byArray2, n3, false);
    }

    public String toString() {
        return this.g;
    }

    protected String setPadding(String string) throws CryptoException {
        if (string == null) {
            string = "NoPadding";
        }
        if (this.e == 1) {
            if (!string.equals("NoPadding")) {
                throw new CryptoException("Stream ciphers must use NoPadding!");
            }
            this.a = 3;
        } else if (string.equals("NoPadding")) {
            this.a = 3;
        } else if (string.equals("PKCS5Padding")) {
            this.a = 4;
        } else if (string.equals("OAEP")) {
            this.a = 5;
        } else {
            throw new CryptoException("Padding must be either NoPadding, OAEP or PKCS5Padding!");
        }
        return string;
    }

    protected String setMode(String string) throws CryptoException {
        if (string == null) {
            string = "ECB";
        }
        if (this.e == 1) {
            if (!string.equals("ECB")) {
                throw new CryptoException("Stream ciphers must use ECB!");
            }
            this.chainingMode = 5;
        } else if (string.equals("ECB")) {
            this.chainingMode = 5;
        } else if (string.equals("CBC")) {
            this.chainingMode = 6;
        } else {
            throw new CryptoException("Mode must be either ECB or CBC!");
        }
        return string;
    }

    public static void register(String string, String string2) {
        if (string2 == null) {
            string2 = String.valueOf(b) + string;
        }
        f.put(string, string2);
    }

    public abstract void init(int var1, CryptoBag var2, Object var3, SecureRandom var4) throws CryptoException;

    public final void init(int n, CryptoBag cryptoBag) throws CryptoException {
        this.init(n, cryptoBag, null, null);
    }

    private static void a() {
        f = new Hashtable(10);
        Cipher.register("RC2", null);
        Cipher.register("ARCFOUR", null);
        Cipher.register("RC4", (String)f.get("ARCFOUR"));
        Cipher.register("DES", null);
        Cipher.register("TripleDES", null);
        Cipher.register("DESede", (String)f.get("TripleDES"));
        Cipher.register("IDEA", null);
        Cipher.register("Rijndael", null);
        Cipher.register("AES", (String)f.get("Rijndael"));
        Cipher.register("RSA", "iaik.me.security.rsa.RSA");
    }

    public abstract int[] getKeyLength();

    public static Cipher getInstance(String string) throws CryptoException {
        string = ASN1.getName(string);
        SimpleStringTokenizer simpleStringTokenizer = new SimpleStringTokenizer(string, '/');
        String string2 = simpleStringTokenizer.nextToken();
        String string3 = simpleStringTokenizer.hasMoreTokens() ? simpleStringTokenizer.nextToken() : null;
        String string4 = simpleStringTokenizer.hasMoreTokens() ? simpleStringTokenizer.nextToken() : null;
        Class clazz = Util.loadClass((String)f.get(string2));
        if (clazz == null) {
            throw new CryptoException("Algorithm " + string2 + " not available!");
        }
        try {
            Cipher cipher = (Cipher)clazz.newInstance();
            string3 = cipher.setMode(string3);
            string4 = cipher.setPadding(string4);
            cipher.g = String.valueOf(string2) + '/' + string3 + '/' + string4;
            return cipher;
        }
        catch (CryptoException cryptoException) {
            throw cryptoException;
        }
        catch (Exception exception) {
            throw new CryptoException(exception.toString());
        }
    }

    public CryptoBag getIV() {
        if (this.iv == null) {
            return null;
        }
        return CryptoBag.makeIV(this.iv);
    }

    public int getBlockSize() {
        return this.e;
    }

    protected void extractIV(int n, Object object, SecureRandom secureRandom) throws CryptoException {
        this.iv = null;
        if (object instanceof CryptoBag) {
            CryptoBag cryptoBag = (CryptoBag)object;
            if (cryptoBag.getType() == 2) {
                this.iv = cryptoBag.getByteArray(1);
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n2 = 0;
            while (n2 < objectArray.length) {
                CryptoBag cryptoBag;
                if (objectArray[n2] instanceof CryptoBag && (cryptoBag = (CryptoBag)objectArray[n2]).getType() == 2) {
                    this.iv = cryptoBag.getByteArray(1);
                    break;
                }
                ++n2;
            }
        }
        if (this.iv == null) {
            if (n == 2) {
                throw new CryptoException("IV must be specified in decrypt mode!");
            }
            if (secureRandom == null) {
                secureRandom = SecureRandom.getDefault();
            }
            this.iv = new byte[this.e];
            secureRandom.nextBytes(this.iv);
        } else if (this.iv.length != this.e) {
            throw new CryptoException("IV length must match block size!");
        }
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        int n4 = this.updateInternal(byArray, n, n2, byArray2, n3, true);
        if (this.a == 3) {
            if (this.c != 0) {
                throw new CryptoException("Total amount of data must be a multiple of blocksize for NoPadding!");
            }
        } else if (this.mode == 1) {
            int n5 = this.e - this.c;
            while (this.c < this.e) {
                this.d[this.c++] = (byte)n5;
            }
            this.cryptBlock(this.d, 0, byArray2, n3 + n4);
            this.c = 0;
            n4 += this.e;
        } else {
            if (this.c != 0) {
                throw new CryptoException("Total amount of data must be a multiple of blocksize in decrypt mode!");
            }
            if (n4 < this.e) {
                throw new CryptoException("doFinal() must decrypt at least one block for PKCS#5 unpad!");
            }
            int n6 = byArray2[n3 + n4 - 1] & 0xFF;
            if (n6 < 1 || n6 > this.e) {
                throw new CryptoException("Invalid PKCS#5 padding: " + n6);
            }
            n4 -= n6;
        }
        return n4;
    }

    public byte[] doFinal(byte[] byArray) throws CryptoException {
        byte[] byArray2 = new byte[byArray.length + (this.e << 1)];
        int n = this.doFinal(byArray, 0, byArray.length, byArray2, 0);
        if (n != byArray2.length) {
            byte[] byArray3 = new byte[n];
            CryptoUtils.copyBlock(byArray2, 0, byArray3, 0, n);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    protected void cryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CryptoException {
        throw new CryptoException("Not implemented");
    }

    protected Cipher(int n) {
        this.e = n;
        this.d = new byte[n];
    }

    static {
        Cipher.a();
    }
}

