/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.keymgmt;

import iaik.me.asn1.ASN1;
import iaik.me.asn1.Name;
import iaik.me.keymgmt.EncryptedPrivateKey;
import iaik.me.keymgmt.KeyAndCert;
import iaik.me.security.BigInteger;
import iaik.me.security.Cipher;
import iaik.me.security.CryptoException;
import iaik.me.security.Mac;
import iaik.me.security.PBE;
import iaik.me.security.PrivateKey;
import iaik.me.security.PublicKey;
import iaik.me.security.SecureRandom;
import iaik.me.utils.CryptoUtils;
import iaik.me.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class PKCS12 {
    private Vector f;
    private PrivateKey a;
    private char[] b;
    private KeyAndCert d;
    private byte[] e;
    private ASN1 c;
    private static final String g = "1.2.840.113549.1.9.22.1";
    private static final String h = "1.2.840.113549.1.9.21";
    private static final String i = "1.2.840.113549.1.9.20";
    private static final String n = "1.2.840.113549.1.12.10.1.3";
    private static final String l = "1.2.840.113549.1.12.10.1.2";
    private static final String m = "1.2.840.113549.1.12.10.1.1";
    private static final String j = "1.2.840.113549.1.7.6";
    private static final String k = "1.2.840.113549.1.7.1";
    private static final boolean o = false;

    public boolean verify(char[] cArray) {
        if (this.c == null) {
            return false;
        }
        try {
            ASN1 aSN1 = this.c.getElementAt(0);
            byte[] byArray = this.c.getElementAt(1).gvByteArray();
            int n = this.c.getSize() > 2 ? this.c.getElementAt(2).gvInt() : 1;
            String string = aSN1.getElementAt(0).gvAlgorithm();
            byte[] byArray2 = aSN1.getElementAt(1).gvByteArray();
            PBE pBE = PBE.getInstance(string);
            Mac mac = pBE.getMac(cArray, byArray, n, null);
            mac.update(this.e);
            byte[] byArray3 = mac.doFinal();
            return CryptoUtils.equalsBlock(byArray2, byArray3);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void e(ASN1 aSN1) throws IOException {
        if (aSN1 == null) {
            return;
        }
        Enumeration enumeration = aSN1.gvVector().elements();
        while (enumeration.hasMoreElements()) {
            ASN1 aSN12 = (ASN1)enumeration.nextElement();
            String string = aSN12.getElementAt(0).gvString();
            Vector vector = aSN12.getElementAt(1).gvVector();
            ASN1 aSN13 = vector.size() > 0 ? (ASN1)vector.elementAt(0) : null;
            if (string.equals(i)) continue;
            string.equals(h);
        }
    }

    private void d(ASN1 aSN1) throws IOException {
        String string;
        if (aSN1.getType() != 16 || aSN1.getElementAt(0).getType() != 2) {
            throw new IOException("ASN.1 format error: not a PKCS#12 structure!");
        }
        int n = aSN1.getElementAt(0).gvInt();
        if (n < 3) {
            throw new IOException("Version must be 3 or later");
        }
        ASN1 aSN12 = aSN1.getElementAt(1);
        if (aSN1.getSize() > 2) {
            this.c = aSN1.getElementAt(2);
        }
        if (!(string = aSN12.getElementAt(0).gvString()).equals(k)) {
            throw new IOException("Outer layer must be PKCS#7 data");
        }
        this.e = aSN12.getElementAt(1).gvASN1().gvByteArray();
    }

    private void c(ASN1 aSN1, ASN1 aSN12) throws IOException, CryptoException {
        PKCS12.e(aSN12);
        EncryptedPrivateKey encryptedPrivateKey = new EncryptedPrivateKey(aSN1);
        this.a = encryptedPrivateKey.decrypt(this.b);
    }

    private void c(ASN1 aSN1) throws IOException, CryptoException {
        Vector vector = aSN1.gvVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ASN1 aSN12 = (ASN1)enumeration.nextElement();
            String string = aSN12.getElementAt(0).gvObjectId();
            ASN1 aSN13 = aSN12.getElementAt(1).gvASN1();
            ASN1 aSN14 = null;
            if (aSN12.getSize() > 2) {
                aSN14 = aSN12.getElementAt(2);
            }
            if (string.equals(m)) {
                this.b(aSN13, aSN14);
                continue;
            }
            if (string.equals(l)) {
                this.c(aSN13, aSN14);
                continue;
            }
            if (!string.equals(n)) continue;
            this.a(aSN13, aSN14);
        }
    }

    private void b(ASN1 aSN1, ASN1 aSN12) throws IOException {
        PKCS12.e(aSN12);
        this.a = new PrivateKey(aSN1);
    }

    private void b(ASN1 aSN1) throws IOException, CryptoException {
        int n = aSN1.getElementAt(0).gvInt();
        ASN1 aSN12 = aSN1.getElementAt(1);
        String string = aSN12.getElementAt(0).gvString();
        if (!string.equals(k)) {
            throw new IOException("Contained content type must be data: " + string);
        }
        ASN1 aSN13 = aSN12.getElementAt(1);
        String string2 = aSN13.getElementAt(0).gvString();
        ASN1 aSN14 = aSN13.getElementAt(1);
        byte[] byArray = aSN14.getElementAt(0).gvByteArray();
        int n2 = aSN14.getElementAt(1).gvInt();
        PBE pBE = PBE.getInstance(string2);
        Cipher cipher = pBE.getCipher(2, this.b, byArray, n2, null);
        ASN1 aSN15 = aSN12.getElementAt(2);
        aSN15.setImplicitTag(4);
        byte[] byArray2 = aSN15.gvASN1().gvByteArray();
        byte[] byArray3 = cipher.doFinal(byArray2);
        this.c(new ASN1(byArray3, 0, false));
    }

    private void a(ASN1 aSN1) throws IOException, CryptoException {
        ASN1 aSN12 = new ASN1(aSN1.gvByteArray(), 0, false);
        this.c(aSN12);
    }

    private void a(ASN1 aSN1, ASN1 aSN12) throws IOException {
        PKCS12.e(aSN12);
        String string = aSN1.getElementAt(0).gvString();
        if (string.equals(g)) {
            byte[] byArray = aSN1.getElementAt(1).gvASN1().gvByteArray();
            X509Certificate x509Certificate = new X509Certificate(byArray);
            this.f.addElement(x509Certificate);
        }
    }

    private static String a(X509Certificate x509Certificate) {
        Name name = x509Certificate.getSubjectDN();
        String string = name.getRDN("2.5.4.3");
        if (string == null && (string = name.getRDN("1.2.840.113549.1.9.1")) == null) {
            string = name.toString();
        }
        return string;
    }

    public byte[] encrypt(char[] cArray, String string, int n) throws CryptoException {
        Object object;
        Object object2;
        if (string == null) {
            string = "1.2.840.113549.1.12.1.3";
        }
        PrivateKey privateKey = this.d.getPrivateKey();
        X509Certificate[] x509CertificateArray = this.d.getCertificateChain();
        ASN1 aSN1 = new ASN1(17, new Vector(1));
        byte[] byArray = new byte[8];
        SecureRandom.getDefault().nextBytes(byArray);
        aSN1.addElement(new ASN1(4, byArray));
        ASN1 aSN12 = ASN1.makeSequence(2);
        aSN12.addElement(new ASN1(6, h));
        aSN12.addElement(aSN1);
        ASN1 aSN13 = new ASN1(17, new Vector(1));
        aSN13.addElement(new ASN1(30, PKCS12.a(x509CertificateArray[0])));
        ASN1 aSN14 = ASN1.makeSequence(2);
        aSN14.addElement(new ASN1(6, i));
        aSN14.addElement(aSN13);
        ASN1 aSN15 = new ASN1(17, new Vector(2));
        aSN15.addElement(aSN14);
        aSN15.addElement(aSN12);
        ASN1 aSN16 = ASN1.makeSequence(x509CertificateArray.length + 1);
        ASN1 aSN17 = EncryptedPrivateKey.encrypt(privateKey, cArray, string, 1);
        ASN1 aSN18 = ASN1.makeSequence(3);
        aSN18.addElement(new ASN1(6, l));
        aSN18.addElement(new ASN1(Integer.MIN_VALUE, (Object)aSN17));
        aSN18.addElement(aSN15);
        aSN16.addElement(aSN18);
        int n2 = 0;
        while (n2 < x509CertificateArray.length) {
            object2 = ASN1.makeSequence(2);
            ((ASN1)object2).addElement(new ASN1(6, g));
            ((ASN1)object2).addElement(new ASN1(Integer.MIN_VALUE, (Object)new ASN1(4, x509CertificateArray[n2].getEncoded())));
            object = ASN1.makeSequence(3);
            ((ASN1)object).addElement(new ASN1(6, n));
            ((ASN1)object).addElement(new ASN1(Integer.MIN_VALUE, object2));
            if (n2 == 0) {
                ((ASN1)object).addElement(aSN15);
            }
            aSN16.addElement((ASN1)object);
            ++n2;
        }
        object2 = aSN16.getEncoded();
        object = PBE.getInstance(string);
        Cipher cipher = ((PBE)object).getCipher(1, cArray, null, n, null);
        byte[] byArray2 = cipher.doFinal((byte[])object2);
        ASN1 aSN19 = ASN1.makeSequence(2);
        aSN19.addElement(new ASN1(4, ((PBE)object).getSalt()));
        aSN19.addElement(new ASN1(2, BigInteger.valueOf(((PBE)object).getIterationCount())));
        ASN1 aSN110 = ASN1.makeSequence(3);
        aSN110.addElement(new ASN1(6, k));
        aSN110.addElement(ASN1.makeAlgorithmId(string, aSN19));
        aSN110.addElement(new ASN1(Integer.MIN_VALUE, (Object)new ASN1(4, byArray2, true)));
        ASN1 aSN111 = ASN1.makeSequence(2);
        aSN111.addElement(new ASN1(2, BigInteger.ZERO));
        aSN111.addElement(aSN110);
        ASN1 aSN112 = ASN1.makeSequence(2);
        aSN112.addElement(new ASN1(6, j));
        aSN112.addElement(new ASN1(Integer.MIN_VALUE, (Object)aSN111));
        ASN1 aSN113 = ASN1.makeSequence(1);
        aSN113.addElement(aSN112);
        this.e = aSN113.getEncoded();
        ASN1 aSN114 = ASN1.makeSequence(2);
        aSN114.addElement(new ASN1(6, k));
        aSN114.addElement(new ASN1(Integer.MIN_VALUE, (Object)new ASN1(4, this.e)));
        String string2 = "1.3.14.3.2.26";
        PBE pBE = PBE.getInstance(string2);
        Mac mac = pBE.getMac(cArray, null, n, null);
        mac.update(this.e);
        byte[] byArray3 = mac.doFinal();
        ASN1 aSN115 = ASN1.makeSequence(2);
        aSN115.addElement(ASN1.makeAlgorithmId(string2, null));
        aSN115.addElement(new ASN1(4, byArray3));
        this.c = ASN1.makeSequence(3);
        this.c.addElement(aSN115);
        this.c.addElement(new ASN1(4, pBE.getSalt()));
        this.c.addElement(new ASN1(2, BigInteger.valueOf(pBE.getIterationCount())));
        ASN1 aSN116 = ASN1.makeSequence(3);
        aSN116.addElement(new ASN1(2, BigInteger.valueOf(3L)));
        aSN116.addElement(aSN114);
        aSN116.addElement(this.c);
        return aSN116.getEncoded();
    }

    public byte[] encrypt(char[] cArray) throws CryptoException {
        return this.encrypt(cArray, null, 0);
    }

    public KeyAndCert decrypt(char[] cArray) throws CryptoException {
        try {
            try {
                Object[] objectArray;
                Object object;
                this.b = cArray;
                this.f = new Vector();
                this.a = null;
                ASN1 aSN1 = new ASN1(this.e);
                Vector vector = aSN1.gvVector();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (ASN1)enumeration.nextElement();
                    objectArray = ((ASN1)object).getElementAt(0).gvString();
                    ASN1 aSN12 = ((ASN1)object).getElementAt(1).gvASN1();
                    if (objectArray.equals(k)) {
                        this.a(aSN12);
                        continue;
                    }
                    if (objectArray.equals(j)) {
                        this.b(aSN12);
                        continue;
                    }
                    throw new IOException("Unsupported PKCS#7 type: " + (String)objectArray);
                }
                if (this.a == null || this.f.size() == 0) {
                    throw new CryptoException("No private key or certificate found!");
                }
                object = this.a.getPublicKey();
                objectArray = null;
                try {
                    objectArray = X509Certificate.arrangeCertificateChain((PublicKey)object, this.f);
                }
                catch (CryptoException cryptoException) {
                    objectArray = new X509Certificate[this.f.size()];
                    this.f.copyInto(objectArray);
                }
                this.d = new KeyAndCert((X509Certificate[])objectArray, this.a);
            }
            catch (IOException iOException) {
                throw new CryptoException("Parsing error: " + iOException.toString());
            }
            Object var3_9 = null;
            this.b = null;
            this.a = null;
            this.f = null;
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            this.b = null;
            this.a = null;
            this.f = null;
            throw throwable;
        }
        return this.d;
    }

    public PKCS12(InputStream inputStream) throws IOException {
        ASN1 aSN1 = new ASN1(inputStream, 0, true);
        this.d(aSN1);
    }

    public PKCS12(KeyAndCert keyAndCert) {
        this.d = keyAndCert;
    }

    static {
        ASN1.register(k, "PKCS#7 data");
        ASN1.register(j, "PKCS#7 encrypted data");
        ASN1.register(m, "PKCS#12 key bag");
        ASN1.register(l, "PKCS#12 shrouded key bag");
        ASN1.register(n, "PKCS#12 cert bag");
        ASN1.register(i, "PKCS#9 friendly name");
        ASN1.register(h, "PKCS#9 local id");
        ASN1.register(g, "PKCS#9 X.509 certificate");
    }
}

