/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.asn1;

import iaik.me.asn1.a;
import iaik.me.security.BigInteger;
import iaik.me.utils.CryptoUtils;
import iaik.me.utils.SimpleStringTokenizer;
import iaik.me.utils.SysUtil;
import iaik.me.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

public class ASN1 {
    private static String[] l;
    private int x;
    private boolean f;
    private int c;
    private boolean g;
    private boolean i;
    private byte[] h;
    private Object a;
    private int b;
    private static final int m = 0x3FFFFFFF;
    public static final int CS3 = -2147483645;
    public static final int CS2 = -2147483646;
    public static final int CS1 = -2147483647;
    public static final int CS0 = Integer.MIN_VALUE;
    public static final int TAG_PRIVATE = -1073741824;
    public static final int TAG_CONTEXT_SPECIFIC = Integer.MIN_VALUE;
    public static final int TAG_APPLICATION = 0x40000000;
    public static final int TAG_UNIVERSAL = 0;
    public static final int TYPE_BMP_STRING = 30;
    public static final int TYPE_CHARACTER_STRING = 29;
    public static final int TYPE_UNIVERSAL_STRING = 28;
    public static final int TYPE_GENERAL_STRING = 27;
    public static final int TYPE_VISIBLE_STRING = 26;
    public static final int TYPE_GRAPHIC_STRING = 25;
    public static final int TYPE_GENERALIZED_TIME = 24;
    public static final int TYPE_UTCTIME = 23;
    public static final int TYPE_IA5_STRING = 22;
    public static final int TYPE_VIDEOTEX_STRING = 21;
    public static final int TYPE_T61_STRING = 20;
    public static final int TYPE_PRINTABLE_STRING = 19;
    public static final int TYPE_NUMERIC_STRING = 18;
    public static final int TYPE_SET = 17;
    public static final int TYPE_SEQUENCE = 16;
    static final int j = 15;
    static final int k = 14;
    public static final int TYPE_RELATIVE_OID = 13;
    public static final int TYPE_UTF8_STRING = 12;
    public static final int TYPE_EMBEDDED_PDV = 11;
    public static final int TYPE_ENUMERATED = 10;
    public static final int TYPE_REAL = 9;
    public static final int TYPE_EXTERNAL = 8;
    public static final int TYPE_OBJECT_DESCRIPTOR = 7;
    public static final int TYPE_OBJECT_ID = 6;
    public static final int TYPE_NULL = 5;
    public static final int TYPE_OCTET_STRING = 4;
    public static final int TYPE_BIT_STRING = 3;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_BOOLEAN = 1;
    static final int n = 0;
    private static final int w = 32;
    private static Hashtable d;
    private static Hashtable e;
    public static boolean NULL_PARAMETER;
    public static final String OID_NAME_EMAIL = "1.2.840.113549.1.9.1";
    public static final String OID_NAME_T = "2.5.4.12";
    public static final String OID_NAME_OU = "2.5.4.11";
    public static final String OID_NAME_O = "2.5.4.10";
    public static final String OID_NAME_STREET = "2.5.4.9";
    public static final String OID_NAME_ST = "2.5.4.8";
    public static final String OID_NAME_L = "2.5.4.7";
    public static final String OID_NAME_C = "2.5.4.6";
    public static final String OID_NAME_SERIAL = "2.5.4.5";
    public static final String OID_NAME_SN = "2.5.4.4";
    public static final String OID_NAME_CN = "2.5.4.3";
    public static final String OID_HMAC_SHA1 = "1.2.840.113549.2.7";
    public static final String OID_AES_128_CBC = "2.16.840.1.101.3.4.1.2";
    public static final String OID_DES_EDE_CBC = "1.2.840.113549.3.7";
    public static final String OID_RIPEMD160 = "1.3.36.3.2.1";
    public static final String OID_SHA224 = "2.16.840.1.101.3.4.2.4";
    public static final String OID_SHA256 = "2.16.840.1.101.3.4.2.1";
    public static final String OID_SHA = "1.3.14.3.2.26";
    public static final String OID_MD5 = "1.2.840.113549.2.5";
    public static final String OID_MD2 = "1.2.840.113549.2.2";
    static final String r = "1.3.14.3.2.13";
    static final String s = "1.3.14.3.2.27";
    public static final String OID_SHA1_WITH_DSA = "1.2.840.10040.4.3";
    public static final String OID_RIPEMD160_WITH_RSA_ENCRYPTION = "1.3.36.3.3.1.2";
    public static final String OID_SHA224_WITH_RSA_ENCRYPTION = "1.2.840.113549.1.1.14";
    public static final String OID_SHA256_WITH_RSA_ENCRYPTION = "1.2.840.113549.1.1.11";
    static final String q = "1.3.14.3.2.29";
    public static final String OID_SHA1_WITH_RSA_ENCRYPTION = "1.2.840.113549.1.1.5";
    public static final String OID_MD5_WITH_RSA_ENCRYPTION = "1.2.840.113549.1.1.4";
    public static final String OID_MD2_WITH_RSA_ENCRYPTION = "1.2.840.113549.1.1.2";
    public static final String OID_DH = "1.2.840.113549.1.3.1";
    static final String u = "1.3.14.3.2.12";
    public static final String OID_DSA = "1.2.840.10040.4.1";
    static final String t = "2.5.8.1.1";
    public static final String OID_RSA = "1.2.840.113549.1.1.1";
    public static final String OID_RSAES_OAEP = "1.2.840.113549.1.1.7";
    public static final String OID_MGF1 = "1.2.840.113549.1.1.8";
    public static final String OID_PSPECIFIED = "1.2.840.113549.1.1.9";
    private static final boolean o = false;
    private static final boolean p = false;
    private static final boolean v = false;

    public void setUnusedBits(int n) {
        this.x = n;
    }

    public void setImplicitTag(int n) throws IOException {
        byte[] byArray = this.gvByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.a = new ASN1(byteArrayInputStream, this, n, this.i);
    }

    public static void register(String string, String string2) {
        e.put(string, string2);
        if (d.get(string2) == null) {
            d.put(string2, string);
        }
    }

    static int a(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new IOException("Invalid encoding (EOF)!");
        }
        return n;
    }

    private static Object a(byte[] byArray, int n) throws IOException {
        switch (n) {
            case 4: {
                return byArray;
            }
            case 12: {
                return Util.toUTF8String(byArray);
            }
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                return Util.toASCIIString(byArray);
            }
            case 28: {
                int n2 = byArray.length;
                if ((n2 & 3) != 0) {
                    throw new IOException("Invalid length for universal string: " + n2);
                }
                char[] cArray = new char[n2 >>= 2];
                int n3 = 0;
                int n4 = 0;
                while (n3 < n2) {
                    int n5 = byArray[n4 + 2] & 0xFF;
                    n5 = n5 << 8 | byArray[n4 + 3] & 0xFF;
                    cArray[n3] = (char)n5;
                    ++n3;
                    n4 += 4;
                }
                return new String(cArray);
            }
            case 30: {
                int n6 = byArray.length;
                if ((n6 & 1) != 0) {
                    throw new IOException("Invalid length for bmp string: " + n6);
                }
                char[] cArray = new char[n6 >>= 1];
                int n7 = 0;
                int n8 = 0;
                while (n7 < n6) {
                    int n9 = byArray[n8] & 0xFF;
                    n9 = n9 << 8 | byArray[n8 + 1] & 0xFF;
                    cArray[n7] = (char)n9;
                    ++n7;
                    n8 += 2;
                }
                return new String(cArray);
            }
            case 23: 
            case 24: {
                String string = Util.toASCIIString(byArray);
                return ASN1.a(string, n);
            }
        }
        throw new IOException("Unknown string type " + n);
    }

    public static ASN1 makeString(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '\u007f') {
                return new ASN1(20, string);
            }
            ++n2;
        }
        if (string.indexOf(64) != -1) {
            return new ASN1(22, string);
        }
        return new ASN1(19, string);
    }

    public static ASN1 makeSequence(int n) {
        Vector vector = n < 1 ? new Vector() : new Vector(n);
        return new ASN1(16, vector);
    }

    /*
     * Unable to fully structure code
     */
    private static Date a(String var0, int var1_1) throws IOException {
        var2_2 = TimeZone.getTimeZone("GMT");
        var3_3 = Calendar.getInstance(var2_2);
        var4_4 = 0;
        var5_5 = 0;
        try {
            while (var4_4 < var0.length() - 1) {
                switch (var5_5) {
                    case 0: {
                        if (var1_1 == 23) {
                            var3_3.set(1, var6_6 += (var6_6 = Integer.parseInt(var0.substring(var4_4, var4_4 += 2))) > 50 ? 1900 : 2000);
                            break;
                        }
                        var3_3.set(1, Integer.parseInt(var0.substring(var4_4, var4_4 += 4)));
                        break;
                    }
                    case 1: {
                        var3_3.set(2, Integer.parseInt(var0.substring(var4_4, var4_4 += 2)) - 1);
                        break;
                    }
                    case 2: {
                        var3_3.set(5, Integer.parseInt(var0.substring(var4_4, var4_4 += 2)));
                        break;
                    }
                    case 3: {
                        var3_3.set(11, Integer.parseInt(var0.substring(var4_4, var4_4 += 2)));
                        break;
                    }
                    case 4: {
                        var3_3.set(12, Integer.parseInt(var0.substring(var4_4, var4_4 += 2)));
                        break;
                    }
                    case 5: {
                        var3_3.set(13, Integer.parseInt(var0.substring(var4_4, var4_4 += 2)));
                        break;
                    }
                    case 6: {
                        if (var0.charAt(var4_4) != '+') ** GOTO lbl36
                        var6_6 = var3_3.get(11);
                        var3_3.set(11, var6_6 - Integer.parseInt(var0.substring(++var4_4, var4_4 += 2)));
                        var6_6 = var3_3.get(12);
                        var3_3.set(12, var6_6 - Integer.parseInt(var0.substring(var4_4, var4_4 += 2)));
                        ** GOTO lbl41
lbl36:
                        // 1 sources

                        if (var0.charAt(var4_4) == '-') {
                            var6_6 = var3_3.get(11);
                            var3_3.set(11, var6_6 + Integer.parseInt(var0.substring(++var4_4, var4_4 += 2)));
                            var6_6 = var3_3.get(12);
                            var3_3.set(12, var6_6 + Integer.parseInt(var0.substring(var4_4, var4_4 += 2)));
                        }
                    }
lbl41:
                    // 5 sources

                    case 7: {
                        var4_4 = var0.length();
                    }
                }
                ++var5_5;
            }
        }
        catch (Exception var6_7) {
            throw new IOException("Error parsing date: " + var6_7.toString());
        }
        return var3_3.getTime();
    }

    private static byte[] a(Object object, int n) throws IOException {
        switch (n) {
            case 4: {
                return (byte[])object;
            }
            case 12: {
                return Util.toUTF8ByteArray((String)object);
            }
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                return Util.toASCIIByteArray((String)object);
            }
            case 28: {
                String string = (String)object;
                int n2 = string.length();
                byte[] byArray = new byte[n2 << 2];
                int n3 = 0;
                int n4 = 0;
                while (n3 < n2) {
                    char c = string.charAt(n3);
                    byArray[n4 + 2] = (byte)(c >>> 8);
                    byArray[n4 + 3] = (byte)c;
                    ++n3;
                    n4 += 4;
                }
                return byArray;
            }
            case 30: {
                String string = (String)object;
                int n5 = string.length();
                byte[] byArray = new byte[n5 << 1];
                int n6 = 0;
                int n7 = 0;
                while (n6 < n5) {
                    char c = string.charAt(n6);
                    byArray[n7] = (byte)(c >>> 8);
                    byArray[n7 + 1] = (byte)c;
                    ++n6;
                    n7 += 2;
                }
                return byArray;
            }
            case 23: 
            case 24: {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                calendar.setTime((Date)object);
                StringBuffer stringBuffer = new StringBuffer(24);
                if (n == 23) {
                    ASN1.a(stringBuffer, calendar.get(1));
                } else {
                    stringBuffer.append(calendar.get(1));
                }
                ASN1.a(stringBuffer, calendar.get(2) + 1);
                ASN1.a(stringBuffer, calendar.get(5));
                ASN1.a(stringBuffer, calendar.get(11));
                ASN1.a(stringBuffer, calendar.get(12));
                ASN1.a(stringBuffer, calendar.get(13));
                stringBuffer.append("Z");
                String string = stringBuffer.toString();
                return Util.toASCIIByteArray(string);
            }
        }
        throw new IOException("Unknown string type " + n);
    }

    public static ASN1 makeAlgorithmId(String string, ASN1 aSN1) {
        Vector<ASN1> vector = new Vector<ASN1>();
        vector.addElement(new ASN1(6, ASN1.getObjectId(string)));
        if (NULL_PARAMETER) {
            aSN1 = new ASN1(5, "NULL");
        } else if (aSN1 != null) {
            vector.addElement(aSN1);
        }
        return new ASN1(16, vector);
    }

    public static boolean isObjectId(String string) {
        return string.startsWith("0.") || string.startsWith("1.") || string.startsWith("2.");
    }

    public boolean isConstructed() {
        return this.i;
    }

    private static void c() {
        e = new Hashtable(80);
        d = new Hashtable(80);
        ASN1.register(OID_RSA, "RSA");
        ASN1.register(t, "RSA");
        ASN1.register(OID_DSA, "DSA");
        ASN1.register(u, "DSA");
        ASN1.register(OID_DH, "DH");
        ASN1.register(OID_RSAES_OAEP, "RSAES-OAEP");
        ASN1.register(OID_MGF1, "MGF1");
        ASN1.register(OID_PSPECIFIED, "pSpecifiedEmpty");
        ASN1.register(OID_MD2_WITH_RSA_ENCRYPTION, "MD2withRSA");
        ASN1.register(OID_MD5_WITH_RSA_ENCRYPTION, "MD5withRSA");
        ASN1.register(OID_SHA1_WITH_RSA_ENCRYPTION, "SHA1withRSA");
        ASN1.register(q, "SHA1withRSA");
        ASN1.register(OID_SHA1_WITH_DSA, "SHA1withDSA");
        ASN1.register(s, "SHA1withDSA");
        ASN1.register(r, "SHA1withDSA");
        ASN1.register(OID_MD2, "MD2");
        ASN1.register(OID_MD5, "MD5");
        ASN1.register(OID_SHA, "SHA1");
        ASN1.register(OID_SHA256, "SHA256");
        ASN1.register(OID_SHA224, "SHA224");
        ASN1.register(OID_RIPEMD160, "RIPEMD160");
        ASN1.register(OID_DES_EDE_CBC, "DESede/CBC/PKCS5Padding");
        ASN1.register(OID_AES_128_CBC, "AES/CBC/PKCS5Padding");
        ASN1.register(OID_HMAC_SHA1, "HmacSHA1");
        ASN1.register(OID_NAME_CN, "CN");
        ASN1.register(OID_NAME_SN, "SN");
        ASN1.register(OID_NAME_SERIAL, "serialNumber");
        ASN1.register(OID_NAME_C, "C");
        ASN1.register(OID_NAME_L, "L");
        ASN1.register(OID_NAME_ST, "ST");
        ASN1.register(OID_NAME_STREET, "STREET");
        ASN1.register(OID_NAME_O, "O");
        ASN1.register(OID_NAME_OU, "OU");
        ASN1.register(OID_NAME_T, "T");
        ASN1.register(OID_NAME_EMAIL, "email");
    }

    public int hashCode() {
        return Util.hashCode(this.getEncoded());
    }

    public Vector gvVector() throws IOException {
        if (!(this.a instanceof Vector)) {
            throw new IOException("Not a structured type: " + this.b);
        }
        return (Vector)this.a;
    }

    public String gvString() throws IOException {
        if (!(this.a instanceof String)) {
            throw new IOException("Not a string type: " + this.b);
        }
        return (String)this.a;
    }

    public String gvObjectId() throws IOException {
        if (!(this.a instanceof String)) {
            throw new IOException("Not an object id: " + this.b);
        }
        return (String)this.a;
    }

    public Object gvObject() {
        return this.a;
    }

    public int gvInt() throws IOException {
        BigInteger bigInteger = this.gvBigInteger();
        if (bigInteger.bitLength() > 30) {
            throw new IOException("Integer too large");
        }
        return bigInteger.intValue();
    }

    public Date gvDate() throws IOException {
        if (!(this.a instanceof Date)) {
            throw new IOException("Not a date type: " + this.b);
        }
        return (Date)this.a;
    }

    public byte[] gvByteArray() throws IOException {
        if (!(this.a instanceof byte[])) {
            throw new IOException("Not a byte[] type: " + this.b);
        }
        return (byte[])this.a;
    }

    public boolean gvBoolean() throws IOException {
        if (!(this.a instanceof Boolean)) {
            throw new IOException("Not a boolean type: " + this.b);
        }
        return (Boolean)this.a;
    }

    public BigInteger gvBigInteger() throws IOException {
        if (!(this.a instanceof BigInteger)) {
            throw new IOException("Not a integer type: " + this.b);
        }
        return (BigInteger)this.a;
    }

    public String gvAlgorithm() throws IOException {
        if (this.b != 16) {
            throw new IOException("Not an AlgorithmID: " + this.b);
        }
        return this.getElementAt(0).gvObjectId();
    }

    public ASN1 gvASN1() throws IOException {
        if (this.a instanceof ASN1) {
            return (ASN1)this.a;
        }
        if (this.getTagClass() != Integer.MIN_VALUE || !this.i) {
            throw new IOException("Not an explicit con spec: " + this.b);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.gvByteArray());
        iaik.me.asn1.a.a(byteArrayInputStream);
        ASN1 aSN1 = new ASN1(byteArrayInputStream, this);
        this.a = aSN1;
        return aSN1;
    }

    public int getUnusedBits() {
        return this.x;
    }

    public int getTypeOnly() {
        return this.b & 0x3FFFFFFF;
    }

    private static String i(int n) {
        return null;
    }

    public int getType() {
        return this.b;
    }

    public int getTagClass() {
        return this.b & 0xC0000000;
    }

    public int getSize() throws IOException {
        Vector vector = this.gvVector();
        return vector.size();
    }

    public static String getObjectId(String string) {
        if (ASN1.isObjectId(string)) {
            return string;
        }
        Object v = d.get(string);
        if (v == null) {
            return string;
        }
        return (String)v;
    }

    public static String getName(String string) {
        if (!ASN1.isObjectId(string)) {
            return string;
        }
        Object v = e.get(string);
        if (v == null) {
            return string;
        }
        return (String)v;
    }

    public byte[] getEncoded() {
        if (this.h == null) {
            try {
                this.a();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        return this.h;
    }

    public ASN1 getElementAt(int n) throws IOException {
        Vector vector = this.gvVector();
        if (n < 0 || n >= vector.size()) {
            throw new IOException("Invalid index " + n);
        }
        return (ASN1)vector.elementAt(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ASN1)) {
            return false;
        }
        ASN1 aSN1 = (ASN1)object;
        return CryptoUtils.equalsBlock(this.getEncoded(), aSN1.getEncoded());
    }

    private void a(OutputStream outputStream) throws IOException {
        if (this.f) {
            return;
        }
        int n = (this.b & 0xC0000000) >>> 24;
        if (this.i) {
            n |= 0x20;
        }
        if (this.b <= 30) {
            outputStream.write(n |= this.b & 0x3FFFFFFF);
        } else {
            outputStream.write(n |= 0x1F);
            byte[] byArray = new byte[5];
            int n2 = byArray.length;
            this.b &= 0x3FFFFFFF;
            while (this.b != 0) {
                byArray[--n2] = (byte)(this.b & 0x7F | 0x80);
                this.b >>>= 7;
            }
            int n3 = byArray.length - 1;
            byArray[n3] = (byte)(byArray[n3] & 0x7F);
            outputStream.write(byArray, n2, byArray.length - n2);
        }
    }

    private void h(int n) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Vector vector = this.gvVector();
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (ASN1)enumeration.nextElement();
            n2 += ((ASN1)object).getEncoded().length;
        }
        this.i = true;
        this.a(byteArrayOutputStream);
        this.a(n2, byteArrayOutputStream);
        object = vector.elements();
        while (object.hasMoreElements()) {
            ASN1 aSN1 = (ASN1)object.nextElement();
            byte[] byArray = aSN1.getEncoded();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        this.h = byteArrayOutputStream.toByteArray();
    }

    private void g(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = ASN1.a(this.a, n);
        this.a(byteArrayOutputStream);
        this.a(byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        this.h = byteArrayOutputStream.toByteArray();
    }

    private void f(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.a(byteArrayOutputStream);
        byte[] byArray = (byte[])this.a;
        this.a(byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        this.h = byteArrayOutputStream.toByteArray();
    }

    /*
     * Unable to fully structure code
     */
    private void e(int var1_1) throws IOException {
        block8: {
            block7: {
                var2_2 = new ByteArrayOutputStream();
                this.a(var2_2);
                if (!this.f) {
                    var2_2.write(0);
                }
                var3_3 = new SimpleStringTokenizer((String)this.a, '.');
                if (var1_1 != 6) break block7;
                if (var3_3.countTokens() < 3) {
                    throw new RuntimeException("Invalid ObjectID " + this.a);
                }
                var4_4 = Integer.parseInt(var3_3.nextToken());
                var5_7 = Integer.parseInt(var3_3.nextToken());
                if (var4_4 >= 0 && var4_4 <= 2 && var5_7 >= 0 && var5_7 <= 40) ** GOTO lbl15
                throw new RuntimeException("Invalid ObjectID " + this.a);
lbl-1000:
                // 1 sources

                {
                    var5_7 += 40;
                    --var4_4;
lbl15:
                    // 2 sources

                    ** while (var4_4 > 0)
                }
lbl16:
                // 1 sources

                var2_2.write(var5_7);
                break block8;
            }
            var4_5 = var3_3.nextToken();
            if (var4_5.length() != 0) {
                throw new RuntimeException("Invalid relative oid: " + this.a);
            }
        }
        var4_6 = new byte[10];
        while (var3_3.hasMoreTokens()) {
            var5_8 = Long.parseLong(var3_3.nextToken());
            var7_9 = 9;
            while (var5_8 != 0L) {
                var4_6[var7_9--] = (byte)(128L | var5_8 & 127L);
                var5_8 >>>= 7;
            }
            v0 = var4_6.length - 1;
            var4_6[v0] = (byte)(var4_6[v0] & 127);
            var2_2.write(var4_6, var7_9 + 1, var4_6.length - var7_9 - 1);
        }
        this.h = var2_2.toByteArray();
        if (!this.f) {
            this.h[1] = (byte)(this.h.length - 2);
        }
    }

    private void d(int n) {
        if (!this.f) {
            this.h = new byte[2];
            this.h[0] = 5;
        } else {
            this.h = new byte[0];
        }
    }

    private void a(int n, ByteArrayOutputStream byteArrayOutputStream) {
        if (this.f) {
            return;
        }
        if (n < 128) {
            byteArrayOutputStream.write(n);
        } else if (n < 256) {
            byteArrayOutputStream.write(129);
            byteArrayOutputStream.write(n);
        } else if (n < 65536) {
            byteArrayOutputStream.write(130);
            byteArrayOutputStream.write(n >>> 8);
            byteArrayOutputStream.write(n);
        } else if (n < 0x1000000) {
            byteArrayOutputStream.write(131);
            byteArrayOutputStream.write(n >>> 16);
            byteArrayOutputStream.write(n >>> 8);
            byteArrayOutputStream.write(n);
        } else {
            byteArrayOutputStream.write(132);
            byteArrayOutputStream.write(n >>> 24);
            byteArrayOutputStream.write(n >>> 16);
            byteArrayOutputStream.write(n >>> 8);
            byteArrayOutputStream.write(n);
        }
    }

    private void c(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = this.gvBigInteger().toByteArray();
        byteArrayOutputStream.write(n);
        this.a(byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        this.h = byteArrayOutputStream.toByteArray();
    }

    private void b() throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.a instanceof ASN1) {
            ASN1 aSN1 = (ASN1)this.a;
            this.i = aSN1.f ? aSN1.i : true;
            this.a(byteArrayOutputStream);
            byArray = aSN1.getEncoded();
            this.a(byArray.length, byteArrayOutputStream);
        } else {
            this.a(byteArrayOutputStream);
            byArray = (byte[])this.a;
        }
        byteArrayOutputStream.write(byArray);
        this.h = byteArrayOutputStream.toByteArray();
    }

    private void b(int n) throws IOException {
        if (!this.f) {
            this.h = new byte[3];
            this.h[0] = (byte)n;
            this.h[1] = 1;
        } else {
            this.h = new byte[1];
        }
        this.h[this.h.length - 1] = (byte)((Boolean)this.a != false ? 255 : 0);
    }

    private void a(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = (byte[])this.a;
        int n2 = 0;
        int n3 = byArray.length;
        if (n == -1) {
            while (n3 > 0 && byArray[n3 - 1] == 0) {
                --n3;
            }
            if (n3 > 0) {
                int n4 = byArray[n3 - 1] & 0xFF;
                while ((n4 & 1) == 0) {
                    n4 >>= 1;
                    ++n2;
                }
            }
        } else {
            n2 = n;
        }
        this.a(byteArrayOutputStream);
        this.a(byArray.length + 1, byteArrayOutputStream);
        byteArrayOutputStream.write(n2);
        byteArrayOutputStream.write(byArray, 0, n3);
        this.h = byteArrayOutputStream.toByteArray();
    }

    private void a() throws IOException {
        if (this.getTagClass() == Integer.MIN_VALUE) {
            this.b();
            return;
        }
        switch (this.b) {
            case 1: {
                this.b(this.b);
                break;
            }
            case 3: {
                this.i = false;
                this.a(this.x);
                break;
            }
            case 2: 
            case 10: {
                this.c(this.b);
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                this.i = false;
                this.g(this.b);
                break;
            }
            case 5: {
                this.d(this.b);
                break;
            }
            case 6: 
            case 13: {
                this.e(this.b);
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 29: {
                this.i = true;
                this.h(this.b);
                break;
            }
            default: {
                if (this.i) {
                    this.h(this.b);
                    break;
                }
                this.f(this.b);
            }
        }
    }

    private static int a(InputStream inputStream, int n) throws IOException {
        if ((n &= 0x1F) == 31) {
            int n2;
            n = 0;
            do {
                n2 = ASN1.a(inputStream);
                n <<= 7;
                n |= n2 & 0x7F;
            } while ((n2 & 0x80) != 0);
        }
        return n;
    }

    private void f(a a2, int n) throws IOException {
        a2.d();
        Vector<ASN1> vector = new Vector<ASN1>();
        while (!a2.a()) {
            vector.addElement(new ASN1(a2, this));
        }
        this.a = vector;
    }

    private void e(a a2, int n) throws IOException {
        a2.d();
        byte[] byArray = a2.e();
        this.a = ASN1.a(byArray, n);
    }

    private void g(a a2) throws IOException {
        a2.d();
        byte[] byArray = a2.e();
    }

    private void c(a a2, int n) throws IOException {
        a2.d();
        StringBuffer stringBuffer = new StringBuffer(32);
        if (n == 6) {
            int n2 = ASN1.a(a2);
            int n3 = 0;
            while (n2 > 40) {
                n2 -= 40;
                ++n3;
            }
            if (n3 > 2) {
                throw new IOException("Invalid ObjectID, first element > 2!");
            }
            stringBuffer.append(n3);
            stringBuffer.append('.');
            stringBuffer.append(n2);
        }
        while (!a2.a()) {
            int n4;
            long l = 0L;
            do {
                n4 = ASN1.a(a2);
                l <<= 7;
                l |= (long)(n4 & 0x7F);
            } while (n4 >= 128);
            stringBuffer.append('.');
            stringBuffer.append(l);
        }
        this.a = stringBuffer.toString();
    }

    private void e(a a2) throws IOException {
        a2.d();
        if (!a2.a()) {
            throw new IOException("Invalid NULL encoding!");
        }
        this.a = "NULL";
    }

    private void d(a a2) throws IOException {
        a2.d();
        byte[] byArray = a2.e();
        this.a = new BigInteger(1, byArray);
    }

    private void b(a a2, int n) throws IOException {
        a2.d();
        Vector<ASN1> vector = new Vector<ASN1>();
        while (!a2.a()) {
            vector.addElement(new ASN1(a2, this));
        }
        this.a = vector;
    }

    private void f(a a2) throws IOException {
        a2.d();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (!a2.a()) {
            ASN1 aSN1 = new ASN1(a2, this);
            byteArrayOutputStream.write(aSN1.gvByteArray());
        }
        this.a = byteArrayOutputStream.toByteArray();
    }

    private void c(a a2) throws IOException {
        a2.d();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (!a2.a()) {
            ASN1 aSN1 = new ASN1(a2, this);
            if (aSN1.getType() != 3) {
                throw new IOException("Constructed bit string must consist of bit strings: " + aSN1.getType());
            }
            byteArrayOutputStream.write(aSN1.gvByteArray());
        }
        this.a = byteArrayOutputStream.toByteArray();
    }

    private void b(a a2) throws IOException {
        a2.d();
        int n = ASN1.a(a2);
        if (!a2.a()) {
            throw new IOException("Invalid boolean encoding");
        }
        this.a = n != 0 ? new Boolean(true) : new Boolean(false);
    }

    private void a(a a2) throws IOException {
        a2.d();
        int n = ASN1.a(a2);
        if (n < 0 || n > 7) {
            throw new IOException("Unused bits must be between 0 and 7");
        }
        this.x = n;
        byte[] byArray = a2.e();
        if (byArray.length > 0) {
            int n2 = -1 << n;
            int n3 = byArray.length - 1;
            byArray[n3] = (byte)(byArray[n3] & n2);
        }
        this.a = byArray;
    }

    /*
     * Unable to fully structure code
     */
    private void a(InputStream var1_1, int var2_2, boolean var3_3) throws IOException {
        block26: {
            block27: {
                block28: {
                    var4_4 = new a(var1_1);
                    if (this.c > 0) {
                        var4_4.a(true);
                    }
                    if (var2_2 != 0) {
                        this.f = true;
                        this.b = var2_2;
                        var5_5 = this.b & -1073741824;
                        this.i = var3_3;
                    } else {
                        this.b = ASN1.a(var4_4);
                        var5_5 = (this.b & 192) << 24;
                        this.i = (this.b & 32) != 0;
                        this.b = ASN1.a(var4_4, this.b);
                        this.b = this.b & 0x3FFFFFFF | var5_5;
                    }
                    if (var5_5 != -2147483648) break block26;
                    if (this.i && !this.g) break block27;
                    var6_6 = var4_4.h;
                    var4_4.a(true);
                    var4_4.d();
                    if (var4_4.c()) ** GOTO lbl24
                    this.a = var4_4.e();
                    break block28;
lbl-1000:
                    // 1 sources

                    {
                        new ASN1(var4_4, 0, false);
lbl24:
                        // 2 sources

                        ** while (!var4_4.a())
                    }
                }
                var7_7 = var4_4.b();
                if (this.c > 0) {
                    this.h = var7_7;
                    var8_8 = new byte[var7_7.length - var6_6];
                    CryptoUtils.copyBlock(var7_7, var6_6, var8_8, 0, var8_8.length);
                    this.a = var8_8;
                } else {
                    this.a = var7_7;
                }
                return;
            }
            var4_4.d();
            this.a = new ASN1(var4_4, this);
            this.h = var4_4.b();
            return;
        }
        if (var5_5 != 0) {
            if (this.i) {
                this.b(var4_4, this.b);
            } else {
                this.g(var4_4);
            }
        }
        if (this.i) {
            switch (this.b) {
                case 3: {
                    this.c(var4_4);
                    break;
                }
                case 4: 
                case 7: 
                case 12: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    this.f(var4_4);
                    break;
                }
                case 8: 
                case 11: 
                case 16: 
                case 17: 
                case 29: {
                    this.f(var4_4, this.b);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 13: {
                    throw new IOException("Invalid encoding as constructed for type " + this.b);
                }
                default: {
                    this.b(var4_4, this.b);
                    break;
                }
            }
        } else {
            switch (this.b) {
                case 1: {
                    this.b(var4_4);
                    break;
                }
                case 2: 
                case 10: {
                    this.d(var4_4);
                    break;
                }
                case 3: {
                    this.a(var4_4);
                    break;
                }
                case 4: 
                case 7: 
                case 12: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    this.e(var4_4, this.b);
                    break;
                }
                case 5: {
                    this.e(var4_4);
                    break;
                }
                case 6: 
                case 13: {
                    this.c(var4_4, this.b);
                    break;
                }
                case 0: 
                case 8: 
                case 11: 
                case 16: 
                case 17: 
                case 29: {
                    throw new IOException("Invalid encoding as primitive for type " + this.b);
                }
                default: {
                    this.g(var4_4);
                }
            }
        }
        this.h = var4_4.b();
    }

    public void clearEncoding(boolean bl) {
        this.h = null;
        if (bl) {
            if (this.a instanceof ASN1) {
                ((ASN1)this.a).clearEncoding(true);
            } else if (this.a instanceof Vector) {
                Enumeration enumeration = ((Vector)this.a).elements();
                while (enumeration.hasMoreElements()) {
                    ASN1 aSN1 = (ASN1)enumeration.nextElement();
                    aSN1.clearEncoding(true);
                }
            }
        }
    }

    private static void a(StringBuffer stringBuffer, int n) {
        stringBuffer.append(n / 10 % 10);
        stringBuffer.append(n % 10);
    }

    public void addElement(ASN1 aSN1) {
        ((Vector)this.a).addElement(aSN1);
    }

    public ASN1(byte[] byArray, int n, boolean bl) throws IOException {
        this(new ByteArrayInputStream(byArray), n, bl, 0, false);
    }

    public ASN1(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray), 0, true, 0, false);
    }

    ASN1(InputStream inputStream, ASN1 aSN1, int n, boolean bl) throws IOException {
        this(inputStream, aSN1.c - 1, aSN1.g, n, bl);
    }

    ASN1(InputStream inputStream, ASN1 aSN1) throws IOException {
        this(inputStream, aSN1.c - 1, aSN1.g, 0, false);
    }

    ASN1(InputStream inputStream, int n, boolean bl, int n2, boolean bl2) throws IOException {
        if (n == -1) {
            n = 0;
        } else if (n < 0 || n > 255) {
            n = 255;
        }
        this.c = n;
        this.g = bl;
        this.a(inputStream, n2, bl2);
    }

    public ASN1(InputStream inputStream, int n, boolean bl) throws IOException {
        this(inputStream, n, bl, 0, false);
    }

    public ASN1(InputStream inputStream) throws IOException {
        this(inputStream, 0, true, 0, false);
    }

    public ASN1(int n, Object object, boolean bl) {
        this.b = n;
        this.a = object;
        this.f = bl;
        try {
            switch (n) {
                case 1: {
                    this.gvBoolean();
                    break;
                }
                case 3: 
                case 4: 
                case 9: {
                    this.gvByteArray();
                    break;
                }
                case 2: 
                case 10: {
                    this.gvBigInteger();
                    break;
                }
                case 6: 
                case 7: 
                case 12: 
                case 13: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    this.gvString();
                    break;
                }
                case 23: 
                case 24: {
                    this.gvDate();
                    break;
                }
                case 8: 
                case 11: 
                case 29: {
                    this.gvVector();
                    break;
                }
                case 16: 
                case 17: {
                    this.gvVector();
                    this.i = true;
                    break;
                }
                case 5: {
                    object = "NULL";
                    break;
                }
                default: {
                    if (this.getTagClass() == Integer.MIN_VALUE) {
                        this.gvASN1();
                    } else if (object instanceof Vector) {
                        this.i = true;
                    } else if (!(object instanceof byte[])) {
                        throw new RuntimeException("Unsupported types must be Vector or byte[]");
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public ASN1(int n, Object object) {
        this(n, object, false);
    }

    static {
        NULL_PARAMETER = false;
        ASN1.c();
        SysUtil.toString(null, -1, 1, ":");
        l = null;
    }
}

