/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.tsl.ServiceInfoStatus;
import eu.europa.esig.dss.util.TimeDependentValues;
import java.io.Serializable;

public class ServiceInfo
implements Serializable {
    private static final long serialVersionUID = 4903410679096343832L;
    private String tlCountryCode;
    private String tspName;
    private String tspTradeName;
    private String tspRegistrationIdentifier;
    private String tspPostalAddress;
    private String tspElectronicAddress;
    private String serviceName;
    private TimeDependentValues<ServiceInfoStatus> status = new TimeDependentValues();

    public String getTlCountryCode() {
        return this.tlCountryCode;
    }

    public TimeDependentValues<ServiceInfoStatus> getStatus() {
        return this.status;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTspElectronicAddress() {
        return this.tspElectronicAddress;
    }

    public String getTspName() {
        return this.tspName;
    }

    public String getTspRegistrationIdentifier() {
        return this.tspRegistrationIdentifier;
    }

    public String getTspPostalAddress() {
        return this.tspPostalAddress;
    }

    public String getTspTradeName() {
        return this.tspTradeName;
    }

    public void setTlCountryCode(String tlCountryCode) {
        this.tlCountryCode = tlCountryCode;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = this.trim(serviceName);
    }

    public void setTspElectronicAddress(String tspElectronicAddress) {
        this.tspElectronicAddress = this.trim(tspElectronicAddress);
    }

    public void setTspName(String tspName) {
        this.tspName = this.trim(tspName);
    }

    public void setTspRegistrationIdentifier(String tspRegistrationIdentifier) {
        this.tspRegistrationIdentifier = tspRegistrationIdentifier;
    }

    public void setTspPostalAddress(String tspPostalAddress) {
        this.tspPostalAddress = this.trim(tspPostalAddress);
    }

    public void setTspTradeName(String tspTradeName) {
        this.tspTradeName = this.trim(tspTradeName);
    }

    public void setStatus(TimeDependentValues<ServiceInfoStatus> status) {
        this.status = new TimeDependentValues<ServiceInfoStatus>(status);
    }

    public String toString(String indent) {
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append(indent).append("TSPName                   \t= ").append(this.tspName).append('\n');
            buffer.append(indent).append("ServiceName               \t= ").append(this.serviceName).append('\n');
            buffer.append(indent).append("StatusAndExtensions       \t= ").append(this.status).append('\n');
            buffer.append(indent).append("TSPTradeName              \t= ").append(this.tspTradeName).append('\n');
            buffer.append(indent).append("TSPRegistrationIdentifier \t= ").append(this.tspRegistrationIdentifier).append('\n');
            buffer.append(indent).append("TSPPostalAddress          \t= ").append(this.tspPostalAddress).append('\n');
            buffer.append(indent).append("TSPElectronicAddress      \t= ").append(this.tspElectronicAddress).append("\n\n");
            return buffer.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return str;
    }

    public String toString() {
        return this.toString("");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.tspName == null ? 0 : this.tspName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceInfo other = (ServiceInfo)obj;
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return !(this.tspName == null ? other.tspName != null : !this.tspName.equals(other.tspName));
    }
}

