/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class CertSubjectDNAttributeCondition
extends Condition {
    private static final long serialVersionUID = 5941353274395443267L;
    private final List<String> subjectAttributeOids;

    public CertSubjectDNAttributeCondition(List<String> oids) {
        this.subjectAttributeOids = oids;
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        X500Principal subjectX500Principal = certificateToken.getSubjectX500Principal();
        if (Utils.isCollectionNotEmpty(this.subjectAttributeOids)) {
            for (String oid : this.subjectAttributeOids) {
                String attribute = DSSASN1Utils.extractAttributeFromX500Principal(new ASN1ObjectIdentifier(oid), subjectX500Principal);
                if (!Utils.isStringEmpty(attribute)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("CertSubjectDNAttributeCondition: ").append(this.subjectAttributeOids).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

