/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.mocca;

import at.gv.egiz.smcc.CardNotSupportedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardFactory;
import at.gv.egiz.smcc.util.SmartCardIO;
import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.token.mocca.MOCCAPrivateKeyEntry;
import eu.europa.esig.dss.token.mocca.PINGUIAdapter;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardTerminal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MOCCASignatureTokenConnection
implements SignatureTokenConnection {
    private static final Logger LOG = LoggerFactory.getLogger(MOCCASignatureTokenConnection.class);
    private PINGUIAdapter callback;
    private List<SignatureCard> _signatureCards;

    public MOCCASignatureTokenConnection(PasswordInputCallback callback) {
        this.callback = new PINGUIAdapter(callback);
    }

    public void set_signatureCards(List<SignatureCard> _signatureCards) {
        this._signatureCards = _signatureCards;
    }

    @Override
    public void close() {
        if (this._signatureCards != null) {
            for (SignatureCard c : this._signatureCards) {
                c.disconnect(true);
            }
            this._signatureCards.clear();
            this._signatureCards = null;
        }
    }

    private List<SignatureCard> getSignatureCards() {
        if (this._signatureCards == null) {
            this._signatureCards = new ArrayList<SignatureCard>();
            SmartCardIO io = new SmartCardIO();
            SignatureCardFactory factory = SignatureCardFactory.getInstance();
            for (Map.Entry<CardTerminal, Card> entry : io.getCards().entrySet()) {
                try {
                    this._signatureCards.add(factory.createSignatureCard(entry.getValue(), entry.getKey()));
                }
                catch (CardNotSupportedException e) {
                    LOG.info(e.getMessage());
                }
            }
        }
        return this._signatureCards;
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        List<DSSPrivateKeyEntry> list = this.getKeysSeveralCards();
        if (list.isEmpty()) {
            throw new DSSException("Cannot retrieve keys from the card!");
        }
        return list;
    }

    private List<DSSPrivateKeyEntry> getKeysSeveralCards() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        List<SignatureCard> cardList = this.getSignatureCards();
        int index = 0;
        for (SignatureCard sc : cardList) {
            byte[] data;
            try {
                data = sc.getCertificate(SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR, this.callback);
                if (data != null) {
                    list.add(new MOCCAPrivateKeyEntry(data, SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR, index, sc.getCard().getATR().getBytes()));
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
            try {
                data = sc.getCertificate(SignatureCard.KeyboxName.CERTIFIED_KEYPAIR, this.callback);
                if (data != null) {
                    list.add(new MOCCAPrivateKeyEntry(data, SignatureCard.KeyboxName.CERTIFIED_KEYPAIR, index, sc.getCard().getATR().getBytes()));
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
            ++index;
        }
        return list;
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(toBeSigned.getBytes());
        if (!(keyEntry instanceof MOCCAPrivateKeyEntry)) {
            throw new DSSException("Unsupported DSSPrivateKeyEntry instance " + keyEntry.getClass() + " / Must be MOCCAPrivateKeyEntry.");
        }
        MOCCAPrivateKeyEntry moccaKey = (MOCCAPrivateKeyEntry)keyEntry;
        if (this._signatureCards == null) {
            throw new IllegalStateException("The cards have not been initialised");
        }
        if (moccaKey.getPos() > this._signatureCards.size() - 1) {
            throw new IllegalStateException("Card was removed or disconnected " + moccaKey.getPos() + " " + this._signatureCards.size());
        }
        SignatureCard signatureCard = this._signatureCards.get(moccaKey.getPos());
        EncryptionAlgorithm encryptionAlgo = moccaKey.getEncryptionAlgorithm();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgo, digestAlgorithm);
        LOG.info("MOCCA>>>Signature algorithm: " + signatureAlgorithm.getJCEId());
        try {
            SignatureCard.KeyboxName keyboxName = moccaKey.getKeyboxName();
            byte[] signedData = signatureCard.createSignature(inputStream, keyboxName, this.callback, signatureAlgorithm.getXMLId());
            if (EncryptionAlgorithm.ECDSA.equals((Object)encryptionAlgo)) {
                signedData = MOCCASignatureTokenConnection.encode(signedData);
            }
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(signatureAlgorithm);
            value.setValue(signedData);
            return value;
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf, DSSPrivateKeyEntry keyEntry) throws DSSException {
        throw new UnsupportedOperationException();
    }

    private static byte[] encode(byte[] signedStream) throws DSSException {
        int half = signedStream.length / 2;
        byte[] firstPart = new byte[half];
        byte[] secondPart = new byte[half];
        System.arraycopy(signedStream, 0, firstPart, 0, half);
        System.arraycopy(signedStream, half, secondPart, 0, half);
        BigInteger r = new BigInteger(1, firstPart);
        BigInteger s = new BigInteger(1, secondPart);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(r));
        v.add(new ASN1Integer(s));
        return DSSASN1Utils.getDEREncoded(new DERSequence(v));
    }

    public int getRetries() {
        return this.callback.getRetries();
    }
}

