/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractKeyStoreTokenConnection;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSCAPISignatureToken
extends AbstractKeyStoreTokenConnection {
    private static final Logger LOG = LoggerFactory.getLogger(MSCAPISignatureToken.class);

    private static void _fixAliases(KeyStore keyStore) {
        try {
            Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
            field.setAccessible(true);
            KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
            if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreVeritable.getClass().getName())) {
                field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
                field.setAccessible(true);
                Object entriesObject = field.get(keyStoreVeritable);
                if (entriesObject instanceof Map) {
                    return;
                }
                if (entriesObject instanceof Collection) {
                    Collection entries = (Collection)entriesObject;
                    for (Object entry : entries) {
                        field = entry.getClass().getDeclaredField("certChain");
                        field.setAccessible(true);
                        X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                        String hashCode = Integer.toString(certificates[0].hashCode());
                        field = entry.getClass().getDeclaredField("alias");
                        field.setAccessible(true);
                        String alias = (String)field.get(entry);
                        if (alias.equals(hashCode)) continue;
                        field.set(entry, alias.concat(" - ").concat(hashCode));
                    }
                } else {
                    LOG.warn("Unsupported entries type : " + entriesObject.getClass().getName());
                }
            }
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage(), exception);
        }
    }

    @Override
    KeyStore getKeyStore() throws DSSException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("Windows-MY");
            keyStore.load(null, null);
            MSCAPISignatureToken._fixAliases(keyStore);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DSSException("Unable to load MS CAPI keystore", e);
        }
        return keyStore;
    }

    @Override
    KeyStore.PasswordProtection getKeyProtectionParameter() {
        return new KeyStore.PasswordProtection("nimp".toCharArray());
    }

    @Override
    public void close() {
    }
}

