/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.client.http.MaxSizeInputStream;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;

public class NativeDataLoaderCall
implements Callable<byte[]> {
    private static final String ERROR_MESSAGE = "An error occured while reading from url '%s' : %s";
    private String url;
    private byte[] content;
    private long maxInputSize;
    private boolean useCaches;

    public NativeDataLoaderCall(String url, byte[] content, boolean useCaches, long maxInputSize) {
        this.url = url;
        this.content = content;
        this.useCaches = useCaches;
        this.maxInputSize = maxInputSize;
    }

    @Override
    public byte[] call() {
        OutputStream out = null;
        InputStream inputStream = null;
        byte[] result = null;
        try {
            URLConnection connection = this.createConnection();
            connection.setUseCaches(this.useCaches);
            connection.setDoInput(true);
            if (this.content != null) {
                connection.setDoOutput(true);
                out = connection.getOutputStream();
                Utils.write(this.content, out);
            }
            inputStream = connection.getInputStream();
            result = Utils.toByteArray(this.maxInputSize > 0L ? new MaxSizeInputStream(inputStream, this.maxInputSize, this.url) : inputStream);
        }
        catch (IOException e) {
            try {
                throw new DSSException(String.format(ERROR_MESSAGE, this.url, e.getMessage()), e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(out);
                Utils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        Utils.closeQuietly(out);
        Utils.closeQuietly(inputStream);
        return result;
    }

    protected URLConnection createConnection() throws MalformedURLException, IOException {
        return new URL(this.url).openConnection();
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getContent() {
        return this.content;
    }

    public long getMaxInputSize() {
        return this.maxInputSize;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }
}

