/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.Digest;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.x509.Token;
import java.io.Serializable;
import javax.xml.bind.DatatypeConverter;

public final class TokenIdentifier
implements Serializable {
    private final Digest tokenDigest;

    TokenIdentifier(DigestAlgorithm digestAlgo, byte[] digest) {
        this.tokenDigest = new Digest(digestAlgo, digest);
    }

    public TokenIdentifier(Token token) {
        this(DigestAlgorithm.SHA256, token.getDigest(DigestAlgorithm.SHA256));
    }

    public String asXmlId() {
        return DatatypeConverter.printHexBinary((byte[])this.tokenDigest.getValue());
    }

    public String toString() {
        return "{id:" + this.tokenDigest + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tokenDigest == null ? 0 : this.tokenDigest.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenIdentifier other = (TokenIdentifier)obj;
        return !(this.tokenDigest == null ? other.tokenDigest != null : !this.tokenDigest.equals(other.tokenDigest));
    }
}

