/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.CommonDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class InMemoryDocument
extends CommonDocument {
    private byte[] bytes;

    public InMemoryDocument() {
    }

    public InMemoryDocument(byte[] bytes) {
        this(bytes, null, null);
    }

    public InMemoryDocument(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
        this.mimeType = MimeType.fromFileName(name);
    }

    public InMemoryDocument(byte[] bytes, String name, MimeType mimeType) {
        this.bytes = bytes;
        this.name = name;
        this.mimeType = mimeType;
    }

    public InMemoryDocument(InputStream inputStream) throws DSSException {
        this(DSSUtils.toByteArray(inputStream), null, null);
    }

    public InMemoryDocument(InputStream inputStream, String name) throws DSSException {
        this(DSSUtils.toByteArray(inputStream), name);
    }

    public InMemoryDocument(InputStream inputStream, String name, MimeType mimeType) throws DSSException {
        this(DSSUtils.toByteArray(inputStream), name, mimeType);
    }

    @Override
    public InputStream openStream() throws DSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bytes);
        return byteArrayInputStream;
    }

    public byte[] getBytes() throws DSSException {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getBase64Encoded() {
        return Utils.toBase64(this.bytes);
    }
}

