/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import java.util.HashMap;
import java.util.Map;

public enum EncryptionAlgorithm {
    RSA("RSA", "1.2.840.113549.1.1.1", "RSA/ECB/PKCS1Padding"),
    DSA("DSA", "1.2.840.10040.4.1", "DSA"),
    ECDSA("ECDSA", "1.2.840.10045.2.1", "ECDSA"),
    HMAC("HMAC", "", "");

    private String name;
    private String oid;
    private String padding;

    public static EncryptionAlgorithm forOID(String oid) throws DSSException {
        EncryptionAlgorithm algorithm = (EncryptionAlgorithm)((Object)Registry.OID_ALGORITHMS.get(oid));
        if (algorithm == null) {
            throw new DSSException("Unsupported algorithm: " + oid);
        }
        return algorithm;
    }

    public static EncryptionAlgorithm forName(String name) throws DSSException {
        if ("EC".equals(name) || "ECC".equals(name)) {
            return ECDSA;
        }
        try {
            return EncryptionAlgorithm.valueOf(name);
        }
        catch (Exception e) {
            throw new DSSException("Unsupported algorithm: " + name);
        }
    }

    public static EncryptionAlgorithm forName(String name, EncryptionAlgorithm defaultValue) {
        if ("EC".equals(name) || "ECC".equals(name)) {
            return ECDSA;
        }
        try {
            EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.valueOf(name);
            return encryptionAlgorithm;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private EncryptionAlgorithm(String name, String oid, String padding) {
        this.name = name;
        this.oid = oid;
        this.padding = padding;
    }

    public String getName() {
        return this.name;
    }

    public String getOid() {
        return this.oid;
    }

    public String getPadding() {
        return this.padding;
    }

    private static class Registry {
        private static final Map<String, EncryptionAlgorithm> OID_ALGORITHMS = Registry.registerOIDAlgorithms();

        private Registry() {
        }

        private static Map<String, EncryptionAlgorithm> registerOIDAlgorithms() {
            HashMap<String, EncryptionAlgorithm> map = new HashMap<String, EncryptionAlgorithm>();
            for (EncryptionAlgorithm encryptionAlgorithm : EncryptionAlgorithm.values()) {
                map.put(encryptionAlgorithm.oid, encryptionAlgorithm);
            }
            return map;
        }
    }
}

