/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.LocationResolver;
import dorkbox.util.OS;
import dorkbox.util.Property;
import dorkbox.util.ScreenUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SwingUtil {
    @Property
    public static boolean LOAD_ALL_FONTS;
    @Property
    public static String FONTS_LOCATION;
    @Property
    public static String CUSTOM_LOOK_AND_FEEL;
    public static final Image BLANK_ICON;

    public static Font parseFont(String fontInfo) {
        try {
            int sizeIndex = fontInfo.lastIndexOf(" ");
            String size = fontInfo.substring(sizeIndex + 1);
            int styleIndex = fontInfo.indexOf(" ", sizeIndex - 7);
            String styleString = fontInfo.substring(styleIndex + 1, sizeIndex);
            int style = 0;
            if (styleString.equalsIgnoreCase("bold")) {
                style = 1;
            } else if (styleString.equalsIgnoreCase("italic")) {
                style = 2;
            }
            String fontName = fontInfo.substring(0, styleIndex);
            return new Font(fontName, style, Integer.parseInt(size));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load font info from '" + fontInfo + "'", e);
        }
    }

    public static void showOnSameScreenAsMouse_Center(Container frame) {
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        GraphicsDevice deviceAtMouse = ScreenUtil.getGraphicsDeviceAt(mouseLocation);
        Rectangle bounds = deviceAtMouse.getDefaultConfiguration().getBounds();
        frame.setLocation(bounds.x + bounds.width / 2 - frame.getWidth() / 2, bounds.y + bounds.height / 2 - frame.getHeight() / 2);
    }

    public static void showOnSameScreenAsMouse(Container frame) {
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        GraphicsDevice deviceAtMouse = ScreenUtil.getGraphicsDeviceAt(mouseLocation);
        frame.setLocation(deviceAtMouse.getDefaultConfiguration().getBounds().x, frame.getY());
    }

    public static void addWindowListener(final Component source, final WindowListener listener) {
        if (source instanceof Window) {
            ((Window)source).addWindowListener(listener);
        } else {
            source.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) == 4L) {
                        SwingUtilities.getWindowAncestor(source).addWindowListener(listener);
                    }
                }
            });
        }
    }

    public static void centerInWindow(Window window, Component component) {
        Dimension size = window.getSize();
        Point loc = window.getLocationOnScreen();
        Dimension cmpSize = component.getSize();
        loc.x += (size.width - cmpSize.width) / 2;
        loc.y += (size.height - cmpSize.height) / 2;
        component.setBounds(loc.x, loc.y, cmpSize.width, cmpSize.height);
    }

    public static void browse(Component parent, String uri) {
        boolean cannotBrowse = false;
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(uri));
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IOException ex) {
                cannotBrowse = true;
            }
        } else {
            cannotBrowse = true;
        }
        if (cannotBrowse) {
            JOptionPane.showMessageDialog(parent, "It seems that I can't open a website using your default browser, sorry.");
        }
    }

    public static void invokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeAndWait(runnable);
        }
    }

    public static void invokeAndWaitQuietly(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getVirtualKey(char key) {
        switch (key) {
            case '\b': {
                return 8;
            }
            case '\t': {
                return 9;
            }
            case '\n': {
                return 10;
            }
            case '\u001b': {
                return 27;
            }
            case '\u20ac': {
                return 516;
            }
            case ' ': {
                return 32;
            }
            case '!': {
                return 517;
            }
            case '\"': {
                return 152;
            }
            case '#': {
                return 520;
            }
            case '$': {
                return 515;
            }
            case '&': {
                return 150;
            }
            case '\'': {
                return 222;
            }
            case '(': {
                return 519;
            }
            case ')': {
                return 522;
            }
            case '*': {
                return 151;
            }
            case '+': {
                return 521;
            }
            case ',': {
                return 44;
            }
            case '-': {
                return 45;
            }
            case '.': {
                return 46;
            }
            case '/': {
                return 47;
            }
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
            case ':': {
                return 513;
            }
            case ';': {
                return 59;
            }
            case '<': {
                return 153;
            }
            case '=': {
                return 61;
            }
            case '>': {
                return 160;
            }
            case '@': {
                return 512;
            }
            case 'A': {
                return 65;
            }
            case 'B': {
                return 66;
            }
            case 'C': {
                return 67;
            }
            case 'D': {
                return 68;
            }
            case 'E': {
                return 69;
            }
            case 'F': {
                return 70;
            }
            case 'G': {
                return 71;
            }
            case 'H': {
                return 72;
            }
            case 'I': {
                return 73;
            }
            case 'J': {
                return 74;
            }
            case 'K': {
                return 75;
            }
            case 'L': {
                return 76;
            }
            case 'M': {
                return 77;
            }
            case 'N': {
                return 78;
            }
            case 'O': {
                return 79;
            }
            case 'P': {
                return 80;
            }
            case 'Q': {
                return 81;
            }
            case 'R': {
                return 82;
            }
            case 'S': {
                return 83;
            }
            case 'T': {
                return 84;
            }
            case 'U': {
                return 85;
            }
            case 'V': {
                return 86;
            }
            case 'W': {
                return 87;
            }
            case 'X': {
                return 88;
            }
            case 'Y': {
                return 89;
            }
            case 'Z': {
                return 90;
            }
            case '[': {
                return 91;
            }
            case '\\': {
                return 92;
            }
            case ']': {
                return 93;
            }
            case '^': {
                return 514;
            }
            case '_': {
                return 523;
            }
            case '`': {
                return 192;
            }
            case 'a': {
                return 65;
            }
            case 'b': {
                return 66;
            }
            case 'c': {
                return 67;
            }
            case 'd': {
                return 68;
            }
            case 'e': {
                return 69;
            }
            case 'f': {
                return 70;
            }
            case 'g': {
                return 71;
            }
            case 'h': {
                return 72;
            }
            case 'i': {
                return 73;
            }
            case 'j': {
                return 74;
            }
            case 'k': {
                return 75;
            }
            case 'l': {
                return 76;
            }
            case 'm': {
                return 77;
            }
            case 'n': {
                return 78;
            }
            case 'o': {
                return 79;
            }
            case 'p': {
                return 80;
            }
            case 'q': {
                return 81;
            }
            case 'r': {
                return 82;
            }
            case 's': {
                return 83;
            }
            case 't': {
                return 84;
            }
            case 'u': {
                return 85;
            }
            case 'v': {
                return 86;
            }
            case 'w': {
                return 87;
            }
            case 'x': {
                return 88;
            }
            case 'y': {
                return 89;
            }
            case 'z': {
                return 90;
            }
            case '{': {
                return 161;
            }
            case '}': {
                return 162;
            }
            case '\u007f': {
                return 127;
            }
            case '\u00a1': {
                return 518;
            }
        }
        return 0;
    }

    public static char getFromVirtualKey(int key) {
        switch (key) {
            case 8: {
                return '\b';
            }
            case 9: {
                return '\t';
            }
            case 10: {
                return '\n';
            }
            case 27: {
                return '\u001b';
            }
            case 516: {
                return '\u20ac';
            }
            case 32: {
                return ' ';
            }
            case 517: {
                return '!';
            }
            case 152: {
                return '\"';
            }
            case 520: {
                return '#';
            }
            case 515: {
                return '$';
            }
            case 150: {
                return '&';
            }
            case 222: {
                return '\'';
            }
            case 519: {
                return '(';
            }
            case 522: {
                return ')';
            }
            case 151: {
                return '*';
            }
            case 521: {
                return '+';
            }
            case 44: {
                return ',';
            }
            case 45: {
                return '-';
            }
            case 46: {
                return '.';
            }
            case 47: {
                return '/';
            }
            case 48: {
                return '0';
            }
            case 49: {
                return '1';
            }
            case 50: {
                return '2';
            }
            case 51: {
                return '3';
            }
            case 52: {
                return '4';
            }
            case 53: {
                return '5';
            }
            case 54: {
                return '6';
            }
            case 55: {
                return '7';
            }
            case 56: {
                return '8';
            }
            case 57: {
                return '9';
            }
            case 513: {
                return ':';
            }
            case 59: {
                return ';';
            }
            case 153: {
                return '<';
            }
            case 61: {
                return '=';
            }
            case 160: {
                return '>';
            }
            case 512: {
                return '@';
            }
            case 65: {
                return 'A';
            }
            case 66: {
                return 'B';
            }
            case 67: {
                return 'C';
            }
            case 68: {
                return 'D';
            }
            case 69: {
                return 'E';
            }
            case 70: {
                return 'F';
            }
            case 71: {
                return 'G';
            }
            case 72: {
                return 'H';
            }
            case 73: {
                return 'I';
            }
            case 74: {
                return 'J';
            }
            case 75: {
                return 'K';
            }
            case 76: {
                return 'L';
            }
            case 77: {
                return 'M';
            }
            case 78: {
                return 'N';
            }
            case 79: {
                return 'O';
            }
            case 80: {
                return 'P';
            }
            case 81: {
                return 'Q';
            }
            case 82: {
                return 'R';
            }
            case 83: {
                return 'S';
            }
            case 84: {
                return 'T';
            }
            case 85: {
                return 'U';
            }
            case 86: {
                return 'V';
            }
            case 87: {
                return 'W';
            }
            case 88: {
                return 'X';
            }
            case 89: {
                return 'Y';
            }
            case 90: {
                return 'Z';
            }
            case 91: {
                return '[';
            }
            case 92: {
                return '\\';
            }
            case 93: {
                return ']';
            }
            case 514: {
                return '^';
            }
            case 523: {
                return '_';
            }
            case 192: {
                return '`';
            }
            case 161: {
                return '{';
            }
            case 162: {
                return '}';
            }
            case 127: {
                return '\u007f';
            }
            case 518: {
                return '\u00a1';
            }
        }
        return '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String name;
        LOAD_ALL_FONTS = true;
        FONTS_LOCATION = "resources/fonts";
        CUSTOM_LOOK_AND_FEEL = "Nimbus";
        Toolkit.getDefaultToolkit();
        if (LOAD_ALL_FONTS) {
            boolean isJava6 = OS.javaVersion == 6;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Enumeration<URL> fonts = LocationResolver.getResources(FONTS_LOCATION);
            if (fonts.hasMoreElements()) {
                fonts.nextElement();
                while (fonts.hasMoreElements()) {
                    URL url = fonts.nextElement();
                    InputStream is = null;
                    try {
                        String path = url.toURI().getPath();
                        if (!path.endsWith(".ttf") && (isJava6 || !path.endsWith(".otf"))) continue;
                        is = url.openStream();
                        Font newFont = Font.createFont(0, is);
                        ge.registerFont(newFont);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    catch (FontFormatException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (CUSTOM_LOOK_AND_FEEL != null && !CUSTOM_LOOK_AND_FEEL.isEmpty() && !CUSTOM_LOOK_AND_FEEL.equals(name = UIManager.getLookAndFeel().getName())) {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!CUSTOM_LOOK_AND_FEEL.equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (Exception e) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        BLANK_ICON = new BufferedImage(1, 1, 3);
    }
}

