/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Swt {
    private static final Display currentDisplay = Display.getCurrent();
    private static final Thread currentDisplayThread = currentDisplay.getThread();

    public static void init() {
        if (currentDisplay == null) {
            SystemTray.logger.error("Unable to get the current display for SWT. Please create an issue with your OS and Java version so we may further investigate this issue.");
        }
    }

    public static void dispatch(Runnable runnable) {
        currentDisplay.syncExec(runnable);
    }

    public static boolean isEventThread() {
        return Thread.currentThread() == currentDisplayThread;
    }

    public static void onShutdown(final Runnable runnable) {
        if (Swt.isEventThread()) {
            currentDisplay.getShells()[0].addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    runnable.run();
                }
            });
        } else {
            Swt.dispatch(new Runnable(){

                @Override
                public void run() {
                    currentDisplay.getShells()[0].addListener(21, new Listener(){

                        public void handleEvent(Event event) {
                            runnable.run();
                        }
                    });
                }
            });
        }
    }
}

