/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.swingUI;

import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.swingUI.SwingMenu;
import dorkbox.systemTray.swingUI.SwingUI;
import dorkbox.systemTray.swingUI.TrayPopup;
import dorkbox.util.SwingUtil;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public final class _SwingTray
extends Tray
implements SwingUI {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = true;
    private volatile File imageFile;

    public _SwingTray(SystemTray systemTray) {
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        this.tray = java.awt.SystemTray.getSystemTray();
        SwingMenu swingMenu = new SwingMenu(null){

            @Override
            public void setEnabled(final MenuItem menuItem) {
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean enabled = menuItem.getEnabled();
                        if (_SwingTray.this.visible && !enabled) {
                            _SwingTray.this.tray.remove(_SwingTray.this.trayIcon);
                            _SwingTray.this.visible = false;
                        } else if (!_SwingTray.this.visible && enabled) {
                            try {
                                _SwingTray.this.tray.add(_SwingTray.this.trayIcon);
                                _SwingTray.this.visible = true;
                            }
                            catch (AWTException e) {
                                SystemTray.logger.error("Error adding the icon back to the tray", e);
                            }
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _SwingTray.this.imageFile = menuItem.getImage();
                if (_SwingTray.this.imageFile == null) {
                    return;
                }
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Image trayImage = new ImageIcon(_SwingTray.this.imageFile.getAbsolutePath()).getImage();
                        trayImage.flush();
                        if (_SwingTray.this.trayIcon == null) {
                            _SwingTray.this.trayIcon = new TrayIcon(trayImage);
                            JPopupMenu popupMenu = (JPopupMenu)_native;
                            popupMenu.pack();
                            popupMenu.setFocusable(true);
                            _SwingTray.this.trayIcon.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mousePressed(MouseEvent e) {
                                    TrayPopup popupMenu = (TrayPopup)_native;
                                    popupMenu.doShow(e.getPoint(), 0);
                                }
                            });
                            try {
                                _SwingTray.this.tray.add(_SwingTray.this.trayIcon);
                            }
                            catch (AWTException e) {
                                SystemTray.logger.error("TrayIcon could not be added.", e);
                            }
                        } else {
                            _SwingTray.this.trayIcon.setImage(trayImage);
                        }
                        ((TrayPopup)_native).setTitleBarImage(_SwingTray.this.imageFile);
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void remove() {
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_SwingTray.this.trayIcon != null) {
                            _SwingTray.this.tray.remove(_SwingTray.this.trayIcon);
                            _SwingTray.this.trayIcon = null;
                        }
                        _SwingTray.this.tray = null;
                    }
                });
                super.remove();
            }
        };
        this.bind(swingMenu, null, systemTray);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

