/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.swingUI;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.swingUI.AdjustedJMenuItem;
import dorkbox.systemTray.swingUI.SwingMenu;
import dorkbox.systemTray.util.ImageUtils;
import dorkbox.util.SwingUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

class SwingMenuItemCheckbox
implements CheckboxPeer {
    private final SwingMenu parent;
    private final JMenuItem _native = new AdjustedJMenuItem();
    private volatile ActionListener callback;
    private volatile boolean isChecked = false;
    private static ImageIcon checkedIcon;
    private static ImageIcon uncheckedIcon;

    SwingMenuItemCheckbox(SwingMenu parent) {
        this.parent = parent;
        parent._native.add(this._native);
        if (checkedIcon == null) {
            File checkedFile = ImageUtils.resizeAndCache(ImageUtils.ENTRY_SIZE, ImageUtils.class.getResource("checked_32.png"));
            checkedIcon = new ImageIcon(checkedFile.getAbsolutePath());
            File uncheckedFile = ImageUtils.getTransparentImage(ImageUtils.ENTRY_SIZE);
            uncheckedIcon = new ImageIcon(uncheckedFile.getAbsolutePath());
        }
    }

    @Override
    public void setEnabled(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItemCheckbox.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItemCheckbox.this._native.setText(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(final Checkbox menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    menuItem.setChecked(!SwingMenuItemCheckbox.this.isChecked);
                    ActionListener cb = menuItem.getCallback();
                    if (cb != null) {
                        try {
                            cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    }
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(Checkbox menuItem) {
        char shortcut = menuItem.getShortcut();
        final int vKey = SwingUtil.getVirtualKey(shortcut);
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItemCheckbox.this._native.setMnemonic(vKey);
            }
        });
    }

    @Override
    public void setChecked(Checkbox menuItem) {
        this.isChecked = menuItem.getChecked();
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SwingMenuItemCheckbox.this.isChecked) {
                    SwingMenuItemCheckbox.this._native.setIcon(checkedIcon);
                } else {
                    SwingMenuItemCheckbox.this._native.setIcon(uncheckedIcon);
                }
            }
        });
    }

    @Override
    public void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SwingMenuItemCheckbox.this.callback != null) {
                    SwingMenuItemCheckbox.this._native.removeActionListener(SwingMenuItemCheckbox.this.callback);
                    SwingMenuItemCheckbox.this.callback = null;
                }
                ((SwingMenuItemCheckbox)SwingMenuItemCheckbox.this).parent._native.remove(SwingMenuItemCheckbox.this._native);
                SwingMenuItemCheckbox.this._native.removeAll();
            }
        });
    }
}

