/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import com.sun.jna.Pointer;
import dorkbox.systemTray.jna.linux.Gobject;
import dorkbox.systemTray.jna.linux.Gtk;
import dorkbox.systemTray.peer.EntryPeer;
import dorkbox.systemTray.util.ImageUtils;
import java.io.File;

abstract class GtkBaseMenuItem
implements EntryPeer {
    private static File transparentIcon = null;
    private volatile boolean hasLegitImage = true;
    private volatile Pointer spacerImage;
    protected final Pointer _native;

    GtkBaseMenuItem(Pointer _native) {
        this._native = _native;
        if (transparentIcon == null) {
            transparentIcon = ImageUtils.getTransparentImage(ImageUtils.ENTRY_SIZE);
        }
    }

    public boolean hasImage() {
        return this.hasLegitImage;
    }

    void setLegitImage(boolean isLegit) {
        this.hasLegitImage = isLegit;
    }

    public void setSpacerImage(boolean everyoneElseHasImages) {
        if (this.hasLegitImage) {
            return;
        }
        if (this.spacerImage != null) {
            Gtk.gtk_container_remove(this._native, this.spacerImage);
            this.spacerImage = null;
            Gtk.gtk_widget_show_all(this._native);
        }
        if (everyoneElseHasImages) {
            this.spacerImage = Gtk.gtk_image_new_from_file(transparentIcon.getAbsolutePath());
            Gtk.gtk_image_menu_item_set_image(this._native, this.spacerImage);
            Gtk.gtk_image_menu_item_set_always_show_image(this._native, true);
        }
        Gtk.gtk_widget_show_all(this._native);
    }

    void onDeleteMenu(Pointer parentNative) {
        Gobject.g_object_force_floating(this._native);
        Gtk.gtk_container_remove(parentNative, this._native);
    }

    void onCreateMenu(Pointer parentNative, boolean hasImagesInMenu) {
        this.setSpacerImage(hasImagesInMenu);
        Gtk.gtk_menu_shell_append(parentNative, this._native);
        Gobject.g_object_ref_sink(this._native);
        Gtk.gtk_widget_show_all(this._native);
    }

    @Override
    public void remove() {
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                if (GtkBaseMenuItem.this.spacerImage != null) {
                    Gtk.gtk_container_remove(GtkBaseMenuItem.this._native, GtkBaseMenuItem.this.spacerImage);
                    GtkBaseMenuItem.this.spacerImage = null;
                }
            }
        });
    }
}

