/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.gnomeShell;

import dorkbox.systemTray.SystemTray;
import dorkbox.util.IO;
import dorkbox.util.OSUtil;
import dorkbox.util.Property;
import dorkbox.util.process.ShellProcessBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Extension {
    private static final String UID = "SystemTray@Dorkbox";
    @Property
    public static boolean ENABLE_EXTENSION_INSTALL = true;
    @Property
    public static boolean ENABLE_SHELL_RESTART = true;
    @Property
    public static String SHELL_RESTART_COMMAND = "gnome-shell --replace &";

    public static List<String> getEnabledExtensions() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
        PrintStream outputStream = new PrintStream(byteArrayOutputStream);
        ShellProcessBuilder gsettings = new ShellProcessBuilder(outputStream);
        gsettings.setExecutable("gsettings");
        gsettings.addArgument("get");
        gsettings.addArgument("org.gnome.shell");
        gsettings.addArgument("enabled-extensions");
        gsettings.start();
        String output = ShellProcessBuilder.getOutput(byteArrayOutputStream);
        StringBuilder stringBuilder = new StringBuilder(output);
        int extensionIndex = output.indexOf("]");
        if (extensionIndex > 0) {
            stringBuilder.delete(extensionIndex, stringBuilder.length());
        }
        if ((extensionIndex = output.indexOf("[")) >= 0) {
            stringBuilder.delete(0, extensionIndex + 1);
        }
        String installedExtensions = stringBuilder.toString();
        String[] split = installedExtensions.split(", ");
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            int i1 = s.indexOf("'");
            int i2 = s.lastIndexOf("'");
            if (i1 != 0 || i2 != s.length() - 1) continue;
            split[i] = s.substring(1, s.length() - 1);
        }
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(split));
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.trim().isEmpty()) continue;
            iterator.remove();
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installed extensions are: {}", (Object)strings);
        }
        return strings;
    }

    public static void setEnabledExtensions(List<String> extensions) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
        PrintStream outputStream = new PrintStream(byteArrayOutputStream);
        StringBuilder stringBuilder = new StringBuilder("[");
        int extensionsSize = extensions.size();
        int limit = extensionsSize - 1;
        for (int i = 0; i < extensionsSize; ++i) {
            String extension = extensions.get(i);
            if (extension.isEmpty()) continue;
            stringBuilder.append("'").append(extension).append("'");
            if (i >= limit) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Setting installed extensions to: {}", (Object)stringBuilder.toString());
        }
        ShellProcessBuilder setGsettings = new ShellProcessBuilder(outputStream);
        setGsettings.setExecutable("gsettings");
        setGsettings.addArgument("set");
        setGsettings.addArgument("org.gnome.shell");
        setGsettings.addArgument("enabled-extensions");
        setGsettings.addArgument(stringBuilder.toString());
        setGsettings.start();
    }

    private static void restartShell() {
        if (ENABLE_SHELL_RESTART) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("DEBUG mode enabled. You need to manually restart the shell via '{}'", (Object)SHELL_RESTART_COMMAND);
                return;
            }
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Restarting gnome-shell so tray notification changes can be applied.");
            }
            ShellProcessBuilder restartShell = new ShellProcessBuilder();
            restartShell.addArgument(SHELL_RESTART_COMMAND);
            restartShell.start();
        }
    }

    public static boolean isInstalled() {
        List<String> enabledExtensions = Extension.getEnabledExtensions();
        return enabledExtensions.contains("topIcons@adel.gadllah@gmail.com") || enabledExtensions.contains(UID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void install() {
        block33: {
            List<String> enabledExtensions;
            block29: {
                FileOutputStream fileOutputStream;
                InputStream reader;
                block28: {
                    boolean mkdirs;
                    String metadata;
                    File extensionFile;
                    File metaDatafile;
                    File file;
                    boolean hasSystemTray;
                    block30: {
                        boolean isGnome = OSUtil.DesktopEnv.isGnome();
                        if (!ENABLE_EXTENSION_INSTALL || !isGnome || isGnome && OSUtil.Linux.isDebian()) {
                            return;
                        }
                        String gnomeVersion = OSUtil.DesktopEnv.getGnomeVersion();
                        if (gnomeVersion == null) {
                            return;
                        }
                        enabledExtensions = Extension.getEnabledExtensions();
                        boolean hasTopIcons = enabledExtensions.contains("topIcons@adel.gadllah@gmail.com");
                        hasSystemTray = enabledExtensions.contains(UID);
                        if (hasTopIcons) {
                            return;
                        }
                        System.setProperty("SystemTray_SET_NAME", "true");
                        String userHome = System.getProperty("user.home");
                        file = new File(userHome + "/.local/share/gnome-shell/extensions/" + UID);
                        metaDatafile = new File(file, "metadata.json");
                        extensionFile = new File(file, "extension.js");
                        int indexOf = gnomeVersion.indexOf(46);
                        int nextIndexOf = gnomeVersion.indexOf(46, indexOf + 1);
                        if (indexOf < nextIndexOf) {
                            gnomeVersion = gnomeVersion.substring(0, nextIndexOf);
                        }
                        metadata = "{\n  \"description\": \"Moves the java SystemTray icon from inside the notification drawer to alongside the clock.\",\n  \"name\": \"Dorkbox SystemTray\",\n  \"shell-version\": [\n    \"" + gnomeVersion + "\"\n" + "  ],\n" + "  \"url\": \"https://github.com/dorkbox/SystemTray\",\n" + "  \"uuid\": \"" + UID + "\",\n" + "  \"version\": " + SystemTray.getVersion() + "\n" + "}\n";
                        SystemTray.logger.debug("Checking the gnome-shell extension");
                        if (!hasSystemTray) break block30;
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("Checking current version of extension for upgrade");
                        }
                        StringBuilder builder = new StringBuilder(256);
                        BufferedReader bin = null;
                        try {
                            String line222222;
                            bin = new BufferedReader(new FileReader(metaDatafile));
                            while ((line222222 = bin.readLine()) != null) {
                                builder.append(line222222).append("\n");
                            }
                        }
                        catch (FileNotFoundException line222222) {
                            IO.close(bin, SystemTray.logger);
                        }
                        catch (IOException line222222) {
                            IO.close(bin, SystemTray.logger);
                            {
                                catch (Throwable throwable) {
                                    IO.close(bin, SystemTray.logger);
                                    throw throwable;
                                }
                            }
                        }
                        IO.close(bin, SystemTray.logger);
                        if (metadata.equals(builder.toString())) {
                            if (!SystemTray.DEBUG) {
                                return;
                            }
                            SystemTray.logger.debug("Always upgrading extension in DEBUG mode");
                            hasSystemTray = false;
                        } else {
                            SystemTray.logger.debug("Need to upgrade extension");
                        }
                    }
                    SystemTray.logger.debug("Installing gnome-shell extension");
                    if (!file.isDirectory() && !(mkdirs = file.mkdirs())) {
                        String msg = "Unable to create extension location: " + file;
                        SystemTray.logger.error(msg);
                        return;
                    }
                    BufferedWriter outputWriter = null;
                    try {
                        outputWriter = new BufferedWriter(new FileWriter(metaDatafile, false));
                        outputWriter.write(metadata);
                        outputWriter.flush();
                        outputWriter.close();
                    }
                    catch (IOException e) {
                        try {
                            SystemTray.logger.error("Error installing extension metadata file", e);
                        }
                        catch (Throwable throwable) {
                            IO.close(outputWriter, SystemTray.logger);
                            throw throwable;
                        }
                        IO.close(outputWriter, SystemTray.logger);
                    }
                    IO.close(outputWriter, SystemTray.logger);
                    if (hasSystemTray) break block33;
                    reader = null;
                    fileOutputStream = null;
                    reader = Extension.class.getResourceAsStream("extension.js");
                    fileOutputStream = new FileOutputStream(extensionFile);
                    if (reader != null) break block28;
                    SystemTray.logger.error("The GnomeShell extension.js file cannot be found. Something is severely wrong.");
                    IO.close(reader, SystemTray.logger);
                    IO.close(fileOutputStream, SystemTray.logger);
                    return;
                }
                try {
                    IO.copyStream(reader, fileOutputStream);
                }
                catch (FileNotFoundException e) {
                    SystemTray.logger.error("Cannot find gnome-shell extension", e);
                    IO.close(reader, SystemTray.logger);
                    IO.close(fileOutputStream, SystemTray.logger);
                    break block29;
                }
                catch (IOException e2) {
                    SystemTray.logger.error("Unable to get gnome-shell extension", e2);
                    {
                        catch (Throwable throwable) {
                            IO.close(reader, SystemTray.logger);
                            IO.close(fileOutputStream, SystemTray.logger);
                            throw throwable;
                        }
                    }
                    IO.close(reader, SystemTray.logger);
                    IO.close(fileOutputStream, SystemTray.logger);
                }
                IO.close(reader, SystemTray.logger);
                IO.close(fileOutputStream, SystemTray.logger);
            }
            SystemTray.logger.debug("Enabling extension in gnome-shell");
            if (!enabledExtensions.contains(UID)) {
                enabledExtensions.add(UID);
            }
            Extension.setEnabledExtensions(enabledExtensions);
            Extension.restartShell();
        }
    }

    public static void unInstall() {
        if (!ENABLE_EXTENSION_INSTALL || !OSUtil.DesktopEnv.isGnome()) {
            return;
        }
        List<String> enabledExtensions = Extension.getEnabledExtensions();
        if (enabledExtensions.contains(UID)) {
            enabledExtensions.remove(UID);
            Extension.setEnabledExtensions(enabledExtensions);
            Extension.restartShell();
        }
    }
}

