/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

import java.io.IOException;
import java.io.InputStream;

public abstract class TransparentFileInputStream
extends InputStream {
    private int chunkSize = 256;
    private byte[] buf = new byte[this.chunkSize];
    private int start = 0;
    private int end = 0;
    private int offset = 0;
    private int length = -1;
    private int limit = -1;
    private int mark = -1;
    private int readlimit = -1;

    public TransparentFileInputStream() {
    }

    public TransparentFileInputStream(int n) {
        this.length = n;
    }

    public TransparentFileInputStream(int n, int n2) {
        this.length = n;
        this.chunkSize = n2;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    private int fill() throws IOException {
        if (this.start == this.end && (this.limit < 0 || this.offset < this.limit)) {
            int n = this.limit > 0 && this.limit - this.offset < this.chunkSize ? this.limit - this.offset : (this.length > 0 ? (this.length - this.offset < this.chunkSize ? this.length - this.offset : this.chunkSize - 1) : this.chunkSize);
            byte[] byArray = this.readBinary(this.offset, n);
            this.offset += byArray.length;
            if (this.mark < 0) {
                this.start = 0;
                this.end = byArray.length;
                System.arraycopy(byArray, 0, this.buf, this.start, byArray.length);
            } else {
                if (this.end - this.mark + byArray.length > this.buf.length) {
                    byte[] byArray2 = new byte[this.buf.length * 2];
                    System.arraycopy(this.buf, this.mark, byArray2, 0, this.end - this.mark);
                    this.buf = byArray2;
                } else {
                    System.arraycopy(this.buf, this.mark, this.buf, 0, this.end - this.mark);
                }
                this.start -= this.mark;
                this.end = this.end - this.mark + byArray.length;
                this.mark = 0;
                System.arraycopy(byArray, 0, this.buf, this.start, byArray.length);
            }
            if (n > byArray.length) {
                this.setLimit(this.offset);
            }
        }
        return this.end - this.start;
    }

    protected abstract byte[] readBinary(int var1, int var2) throws IOException;

    @Override
    public int read() throws IOException {
        int n;
        int n2 = n = this.fill() > 0 ? 0xFF & this.buf[this.start++] : -1;
        if (this.readlimit > 0 && this.start > this.readlimit) {
            this.mark = -1;
            this.readlimit = -1;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            if (this.fill() > 0) {
                n4 = Math.min(this.end - this.start, n2 - n3);
                System.arraycopy(this.buf, this.start, byArray, n, n4);
                this.start += n4;
                n += n4;
                if (this.readlimit <= 0 || this.start <= this.readlimit) continue;
                this.mark = -1;
                this.readlimit = -1;
                continue;
            }
            return n3 > 0 ? n3 : -1;
        }
        return n3;
    }

    @Override
    public synchronized void mark(int n) {
        this.readlimit = n;
        this.mark = this.start;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark < 0) {
            throw new IOException();
        }
        this.start = this.mark;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        if (l <= (long)(this.end - this.start)) {
            this.start = (int)((long)this.start + l);
            return l;
        }
        this.mark = -1;
        long l2 = l - (long)(this.end - this.start);
        this.start = this.end;
        if (this.limit >= 0 && (long)this.limit < (long)this.offset + l2) {
            this.offset = this.limit;
            return l - (l2 -= (long)(this.limit - this.offset));
        }
        if (this.length >= 0 && (long)this.length < (long)this.offset + l2) {
            this.offset = this.length;
            return l - (l2 -= (long)(this.length - this.offset));
        }
        this.offset = (int)((long)this.offset + l2);
        return l;
    }
}

